#pragma once

namespace GenericUtility {

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * boost::serialization ŃVACY.
	 */
	template <typename Stream, typename T>
	bool SerializeObject(Stream& os, const T& obj)
	{
		try {
			// XML output archiver
			boost::archive::xml_woarchive oa(os);

			oa << BOOST_SERIALIZATION_NVP(obj);

			return true;
		}
		catch (boost::archive::archive_exception&) {
			return false;
		}
	}

	/**
	 * boost::serialization ŃfVACY.
	 */
	template <typename Stream, typename T>
	bool DeserializeObject(Stream& is, T& obj)
	{
		try {
			// XML input archiver
			boost::archive::xml_wiarchive ia(is);

			ia >> BOOST_SERIALIZATION_NVP(obj);

			return true;
		}
		catch (boost::archive::archive_exception&) {
			return false;
		}
	}

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * boost::serialization ŃVACYāAt@Cɕۑ.
	 */
	template <typename T>
	bool SaveObject(const wchar_t* filename, const T& obj)
	{
		std::wofstream ofs(filename);
		if (!ofs) {
			return false;
		}

		return SerializeObject(ofs, obj);
	}

	/**
	 * t@CǂݍŁAboost::serialization ŃfVACY.
	 */
	template <typename T>
	bool LoadObject(const wchar_t* filename, T& obj)
	{
		std::wifstream ifs(filename);
		if (!ifs) {
			return false;
		}

		return DeserializeObject(ifs, obj);
	}

}	// namespace GenericUtility
