<?php
/**
 *  User/Search.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.view.php,v 1.8 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_searchビューの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_View_UserSearch extends Secioss_ViewClass
{
    /**
     *  遷移前処理
     *
     *  @access public
     */
    function preforward()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $conf = $this->config->get('secioss');

        $this->af->system_select = $auth->getAttrList('system');

        if ($this->session->get('role') == 'system_admin') {
            $filter = array($conf['area']['id'] => '*');
            if (isset($conf['system'])) {
                $filter['system'] = 'master';
            }
            $r = $auth->getObjectPropList('area', null, $filter);
            if (Ethna::isError($r)) {
                $logger->log(LOG_ERR, "Failed to get the tenants: ".$r->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return;
            }
            $tenants = $r[1];

            $idattr = $conf['area']['id'];
            $list = array();
            for ($i = 0; $i < $r[0]; $i++) {
                $list[$tenants[$i][$idattr]] =  $tenants[$i][$idattr];
            }
            $this->af->tenant_select = $list;
        }

        if (!isset($conf['user']['groups']) || !is_array($conf['user']['groups'])) {
            return;
        }

        $list = array();
        foreach ($conf['user']['groups'] as $type => $category) {
            $filter = array($conf['group']['id'] => '*', 'category' => $category);
            if (isset($conf['system'])) {
                $filter['system'] = 'master';
            }
            $r = $auth->getObjectPropList('group', null, $filter);
            if (Ethna::isError($r)) {
                $logger->log(LOG_ERR, "Failed to get the categories: ".$r->getMessage());
                continue;
            }
            $groups = $r[1];

            $list[$type] = array();
            for ($i = 0; $i < $r[0]; $i++) {
                $list[$type][$groups[$i]['id']] =  $groups[$i][$conf['group']['id']];
            }
        }

        $this->af->department_select = $list['department'];
        $this->af->title_select = $list['title'];
    }
}
?>
