<?php
/**
 *  User/InitPwd.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_InitPwdフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserInitPwd extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ユーザID',
        ),
        'snkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'gnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'snkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'gnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'empnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '社員番号'
        ),
        'mail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20
        ),
        'status' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => array('active' => '有効', 'inactive' => '無効'),
        ),
        'certificate' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_FILE,
            'name'          => '証明書'
        ),
        'unlock' => array(
            'type'          => array(VAR_TYPE_BOOLEAN),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => 'ロックアウト解除',
            'option'        => array(true => 'ロックアウト解除')
        ),
        'lockout' => array(
            'type'          => VAR_TYPE_BOOLEAN,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'pwloduration' => array(
            'type'          => VAR_TYPE_INT,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ロックアウトの解除時間（分）',
            'min'           => 0,
            'regexp'        => '/^[0-9]+$/'
        ),
        'sync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'       => true
        ),
        'user_name' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
        ),
        'name' => array(
            'type'          => VAR_TYPE_STRING,
            'name'          => '氏名（漢字）'
        ),
        'namekana' => array(
            'type'          => VAR_TYPE_STRING,
            'name'          => '氏名（かな）'
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  user_InitPwdアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserInitPwd extends Secioss_ActionClass
{
    /**
     *  user_InitPwdアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        if ($this->af->validate() > 0) {
            return 'user_update';
        }

        return null;
    }

    /**
     *  user_InitPwdアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');

        // input value
        $dn = $this->af->get('dn');

        $r = $auth->getObjectList('user', array('id' => $dn));
        if (Ethna::isError($r)) {
            $logger->log(LOG_ERR, "$login_user failed to get the user($dn): ".$r->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'user_update';
        } else if ($r[0] != 1) {
            $logger->log(LOG_ERR, "$login_user gets no user($dn)");
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'user_update';
        }

        $user = $r[1][0];

        $password = $auth->random();
        $rc = $user->initPasswd($password);
        if (Ethna::isError($rc)) {
            $logger->log(LOG_ERR, "$login_user failed to initialize the password of the user($dn): ".$rc->getMessage());
            $this->ae->add(null, O_INITPASSWD_ERR_MSG);

            return 'user_update';
        }

        $message = file_get_contents(INITPWTMPL);
        if ($message === false) {
            $logger->log(LOG_ERR, "Reading mail template failed");
            $this->ae->add(null, 'パスワード初期化メールのテンプレート'.C_FILEOPEN_ERR_MSG);

            return 'user_update';
        }

        if (preg_match("/^Subject: *(.*)\n/i", $message, $matches)) {
            $subject = $matches[1];
            $message = preg_replace("/^Subject:.*\n/i", '', $message);
        }
        $rc = $user->sendMail($subject, null, $message, array('id' => $user->get('uid'), 'name' => $user->get('cn'), 'password' => $password));
        if (!$rc) {
            $logger->log(LOG_ERR, "$login_user failed to send mail to the user($dn) initialized password");
            $this->ae->add(null, 'パスワード初期化'.O_SENDMAIL_ERR_MSG);

            return 'user_update';
        }

        $this->af->setApp('message', O_INITPASSWD_SUCCESS_MSG);
        $logger->log(LOG_INFO, "$login_user succeeded to initialize the password of the user($dn)");

        return 'user_update';
    }
}
?>
