<?php
/**
 *  User/Create.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_createフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserCreate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'newid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ユーザID',
            'regexp'        => '/^[^@&<>" ]*$/',
            'required'      => true
        ),
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ユーザID'
        ),
        'newloginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ログインID'
        ),
        'loginid' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ログインID'
        ),
        'newsnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓',
            'required'      => true
        ),
        'snkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓'
        ),
        'newgnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名',
            'required'      => true
        ),
        'gnkanji' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'newsnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓'
        ),
        'snkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '姓'
        ),
        'newgnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'gnkana' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '名'
        ),
        'newempnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => '社員番号'
        ),
        'empnum' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '社員番号'
        ),
        'newmail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス',
            'regexp'        => '/^[a-zA-Z0-9]+[a-zA-Z0-9\._-]*@[a-zA-Z0-9]+[a-zA-Z0-9\._-]+$/',
        ),
        'mail' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'メールアドレス'
        ),
        'newpassword' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => 4,
            'max'           => 20
        ),
        'newstatus' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => array('active' => '有効', 'inactive' => '無効')
        ),
        'status' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'ユーザ状態',
            'option'        => array('active' => '有効', 'inactive' => '無効'),
        ),
        'pwloduration' => array(
            'type'          => VAR_TYPE_INT,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ロックアウトの解除時間（分）',
            'min'           => 0,
            'max'           => null,
            'default'       => 0,
            'regexp'        => '/^[0-9]+$/'
        ),
        'certificate' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_FILE,
            'name'          => '証明書'
        ),
        'newsync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'sync' => array(
            'type'          => array(VAR_TYPE_STRING),
            'form_type'     => FORM_TYPE_CHECKBOX,
            'name'          => '更新対象システム',
            'option'        => 'sync_select'
        ),
        'newtenant' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'テナント',
            'option'        => 'tenant_select'
        ),
        'newunit' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => '所属',
            'option'        => 'unit_select'
        ),
        'newsystem' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'システム',
            'option'        => 'system_select'
        ),
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );

}

/**
 *  user_createアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserCreate extends Secioss_ActionClass
{
    /**
     *  user_createアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');
        $modules = $this->config->get('modules');
        $host = 'google.com';
        $tenant = null;

        if (isset($modules['Gapps']) && isset($conf['account'])) {
            if ($this->session->get('role') == 'tenant_admin') {
                $tenant = $this->session->get('tenant');
            }

            $filter = array('host' => $host, 'seciossaccountstatus' => 'active');
            if (isset($conf['system'])) {
                $filter['system'] = 'master';
            }
            if ($tenant) {
                $filter['area'] = $tenant;
            }
            $r = $auth->getObjectList('account', $filter);
            if (Ethna::isError($r)) {
                $logger->log(LOG_ERR, "$login_user failed to get the account($host): ".$r->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return 'user_create';
            } else if (!$r[0]) {
                $this->ae->add(null, C_GAPPS_CONFIG_ERR_MSG);

                return 'user_create';
            }
        }

        if ($this->af->get('operation') != "create") {
            return 'user_create';
       }

        if ($this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));
            return 'user_create';
        }

        return null;
    }

    /**
     *  user_createアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');

        // input value
        $id = $this->af->get('newid');
        $loginid = $this->af->get('newloginid');
        $snkanji = $this->af->get('newsnkanji');
        $snkana = $this->af->get('newsnkana');
        $gnkanji = $this->af->get('newgnkanji');
        $gnkana = $this->af->get('newgnkana');
        $empnum = $this->af->get('newempnum');
        $mail = $this->af->get('newmail');
        $password = $this->af->get('newpassword');
        $status = $this->af->get('newstatus');
        $tenant = $this->af->get('newtenant');
        $unit = $this->af->get('newunit');
        $system = $this->af->get('newsystem');
        $sync = $this->af->get('newsync');

        $role = $this->session->get('role');

        if ($role == 'tenant_admin') {
            $tenant = $this->session->get('tenant');
        }

        if (isset($conf['area'])) {
            $id = $id.'@'.$tenant;
        }

        $prop = array(
            'uid' => $id,
            'cn' => "$snkanji $gnkanji",
            'sn' => $snkanji,
            'employeenumber' => $empnum,
            'mail' => $mail
        );

        if ($gnkanji) {
            $prop['givenname'] = $gnkanji;
        }
        if ($snkana) {
            $prop['cn;lang-ja;phonetic'] = "$snkana $gnkana";
            $prop['sn;lang-ja;phonetic'] = $snkana;
        }
        if ($gnkana) {
            $prop['givenname;lang-ja;phonetic'] = $gnkana;
        }
        if (isset($conf['user']['loginidattr'])) {
            $prop[$conf['user']['loginidattr']] = $loginid;
        } else if (array_search('seciossiamaccount', $conf['user']['objectclass']) !== false) {
            $prop['seciosssystemid'] = preg_replace('/@.+$/', '', $id);
        }
        if (isset($conf['user']['statusattr'])) {
            $prop[$conf['user']['statusattr']] = $status;
        }
        if (isset($conf['user']['pwlodurationattr'])) {
            $prop['pwdattribute'] = '2.5.4.35';
        }
        if ($tenant) {
            $prop['area'] = $tenant;
        }
        if ($unit) {
            $prop['parent'] = $unit;
        }
        if ($system) {
            $prop['system'] = $system;
        }
        if (isset($conf['sync'])) {
            $prop['seciossallowedservice'] = $sync;
        }
        if (isset($conf['user']['userdefinedattr'])) {
            foreach ($conf['user']['userdefinedattr'] as $key => $name) {
                if (isset($_POST['attr_'.$key])) {
                    $prop[$key] = $_POST['attr_'.$key];
                    $this->af->setApp($key, $_POST['attr_'.$key]);
                }
            }
        }
        if ($password) {
            $prop['userpassword'] = Secioss_User::getLdapPasswd($password);
        }

        // add user data
        $user = $auth->addObject('user', $prop);
        if (Ethna::isError($user)) {
            $logger->log(LOG_ERR, "$login_user failed to add the user($id): ".$user->getMessage());
            $this->ae->add(null, O_ADD_ERR_MSG);

            return 'user_create';
        }

        $this->af->set('dn', $user->getId());
        $this->af->set('id', $user->get('uid'));
        $this->af->set('empnum', $user->get('employeenumber'));
        $this->af->set('loginid', $loginid);
        $this->af->set('snkanji', $snkanji);
        $this->af->set('gnkanji', $gnkanji);
        $this->af->set('snkana', $snkana);
        $this->af->set('gnkana', $gnkana);
        $this->af->set('mail', $mail);
        $this->af->set('status', $status);
        $this->af->set('operation', null);

        if (isset($conf['sync'])) {
            $this->af->set('sync', $sync);
        }
        $this->session->set('user_name', $user->get('cn'));
        if ($role == 'system_admin') {
            $this->session->set('tenant', $tenant);
        }
        if (isset($conf['unit'])) {
            $this->session->set('unit', $auth->getAttrName('unit', $unit));
        }
        if (isset($conf['system'])) {
            $this->session->set('system', $system);
        }

        $this->af->set('operation', 'read');

        $this->af->setApp('message', O_ADD_SUCCESS_MSG);
        $logger->log(LOG_INFO, "$login_user succeded to create the user(".$user->getId().")");

        return 'user_update';
    }
}
?>
