<?php
/**
 *  System/Read.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php 387 2006-11-06 14:31:24Z cocoitiban $
 */

/**
 *  System_Readフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SystemRead extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        ),
        'search' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
        )
    );
}

/**
 *  System_Readアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SystemRead extends Secioss_ActionClass
{
    /**
     *  System_Readアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        return null;
    }

    /**
     *  System_Readアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $confmgr =& $this->backend->getManager('Config');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');

        $list = array();

        $values = $confmgr->getXmlFile(LISMCONF, array('master', 'sync_cluster'));
        if (Ethna::isError($values)) {
            $logger->log(LOG_ERR, "$login_user failed to get the clusters: ".$values->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

           return 'System_Read';
        }
        $servers = array();
        $master = $values[0];
        if ($master) {
            $servers[] = $master;
        }
        if (count($values[1])) {
            $servers = array_merge($servers, $values[1]);
        }

        $active_clusters = $auth->readCluster('cluster');
        if (Ethna::isError($active_clusters)) {
            $logger->log(LOG_ERR, "$login_user failed to get the active clusters: ".$active_clusters->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'System_Read';
        }

        foreach ($servers as $cluster) {
          list($ldaptype, $uri) = $confmgr->getXmlFile(LISMCONF, array('storage', 'uri'), $cluster);
          if (array_search($cluster, $active_clusters) !== false) {
              $status = '有効';
          } else {
              $status = '無効';
          }
          $list[] = array('dn' => $cluster,
                          'synctype' => $master == $cluster ? 'master' : 'slave',
                          'ldaptype' => $ldaptype,
                          'uri' => $uri,
                          'status' => $status
                    );
        }
        $this->af->setApp('total_num', count($list));
        $this->af->setApp('list', $list);

        return 'System_Read';
    }
}
?>
