<?php
/**
 *  Sync/Update.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  sync_updateフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SyncUpdate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'systems' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'      => true
        ),
        'filter'  => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
        )
    );
}

/**
 *  sync_updateアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SyncUpdate extends Secioss_ActionClass
{
    /**
     *  sync_updateアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        return null;
    }

    /**
     *  sync_updateアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $conf = $this->config->get('secioss');
        $login_user = $this->session->get('user');

        $base = null;
        $tenant = $this->session->get('tenant');
        if ($tenant) {
            $base = $conf['area']['id']."=$tenant";
            if (isset($conf['secioss'])) {
                $base = "$base,ou=Master";
            }
        }

        $filter = $this->af->get('filter');
        //エスケープしていた空白を元にもどす
        $filter = preg_replace('/\\\20/'," ",$filter);
        $systems = $this->af->get('systems');

        if($auth->updateSync($systems, $filter, $base)) {
            $logger->log(LOG_ERR, "$login_user failed to update lismsync");
            $this->ae->add(null, S_INTERNAL_ERR_MSG);
        } else {
            $this->af->setApp('message', O_SYNC_SUCCESS_MSG);
        }

        return 'sync_update';
    }
}
?>
