<?php
/**
 *  Login.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  loginフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_Login extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'id' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'ユーザID',
            'min'           => null,
            'max'           => null,
            'regexp'        => null,
            'required'      => true
        ),
        'password' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'パスワード',
            'min'           => null,
            'max'           => null,
            'regexp'        => null
        )
    );
}

/**
 *  loginアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_Login extends Secioss_ActionClass
{
    function authenticate()
    {
    }

    /**
     *  loginアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        if (isset($_SERVER['REMOTE_USER']) && $_SERVER['REMOTE_USER']) {
            $this->af->set('id', $_SERVER['REMOTE_USER']);
        }

        if ($this->af->validate() > 0) {
            return 'login';
        }

        return null;
    }

    /**
     *  loginアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $conf = $this->config->get('secioss');
        $authtype = isset($_SERVER['REMOTE_USER']) && $_SERVER['REMOTE_USER'] ? 'sso' : 'form';
        $binddn = '';
        $bindpw ='';
        $rc = false;

        $id = $this->af->get('id');
        $password = $this->af->get('password');

        if ($authtype != 'sso') {
            $fp = fopen(PASSWD, 'r');
            if ($fp === false) {
                $logger->log(LOG_ERR, "Can't open ".PASSWD);
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return 'login';
            }

            while (!feof($fp)) {
                $buffer = fgets($fp);
                $buffer = rtrim($buffer, "\n");
                list($user, $crypted) = split(":", $buffer);
                if ($user == $id) {
                    if ($crypted == crypt($password, substr($crypted, 0, 2))) {
                        $rc = true;
                    }
                    break;
                }
            }
        }

        if (!$rc && (!isset($conf['admin_path']) || !preg_match('#^'.$conf['admin_path'].'#', $_SERVER['SCRIPT_NAME']))) {
            $rc = $auth->auth($id, $password, $authtype);
            if (Ethna::isError($rc)) {
                $logger->log(LOG_ERR, "Authentication($id) error: ".$rc->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                if ($authtype == 'sso') {
                    return 'fatal';
                } else {
                    return 'login';
                }
            }
            $binddn = $auth->getUser();
            $bindpw = $auth->getPassword();
        }

        if (!$rc) {
            $logger->log(LOG_ERR, "Authentication($id) failed");
            $this->ae->add(null, S_AUTHENTICATION_ERR_MSG);

            if ($authtype == 'sso') {
                return 'fatal';
            } else {
                return 'login';
            }
        }

        $tenant = preg_match('/@(.+)$/', $id, $matches) ? $matches[1] : null;

        $this->session->start();
        $this->session->set('user', $id);
        if ($binddn) {
            $this->session->set('binddn', $binddn);
        }
        if ($bindpw) {
            $this->session->set('bindpw', $bindpw);
        }
        if (isset($conf['area'])) {
            if ($tenant) {
                $this->session->set('role', 'tenant_admin');
                $this->session->set('tenant', $tenant);
            } else {
                $this->session->set('role', 'system_admin');
            }
        }
        $this->session->set('authtype', $authtype);

        return 'index';
    }
}
?>
