<?php
/**
 *  Secioss_ActionClass.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: app.actionclass.php 323 2006-08-22 15:52:26Z fujimoto $
 */

define("BASEDIR", dirname(dirname(__FILE__)));
define('PASSWD', BASEDIR.'/etc/passwd');
define('HOSTS', BASEDIR.'/etc/hosts');
define('SSOCONF', '/etc/httpd/conf/sso.conf');
define('INITPWTMPL', BASEDIR.'/conf/mail/initpw.mail');
define('SCRIPT', BASEDIR.'/bin/samadmin');
if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    define('CONFIG', '/var/www/conf/config.ini');
    if (file_exists('/var/www/conf/sam.conf')) {
        define('LOGINCONF', '/var/www/conf/sam.conf');
    } else {
        define('LOGINCONF', '/var/www/conf/login.conf');
    }
    define('SAMLDIR', '/usr/share/simplesamlphp');
    define('SAMLLDAPCONF', SAMLDIR.'/config/ldap.php');
    define('OPENIDCONF', '/usr/share/samopenid/conf/config.ini');
    define('LISMCONF', '/opt/secioss/etc/lism.conf');
    define('LISMSVRCONF', '/opt/secioss/etc/lism-server.conf');
    define('LISMRELOAD', '/opt/secioss/sbin/lismconfig reload >& /dev/null');
    define('LISMSYNC', '/opt/secioss/sbin/lismsync');
} else {
    define('CONFIG', '/secioss/var/www/conf/config.ini');
    define('LOGINCONF', '/secioss/var/www/conf/login.conf');
    define('SAMLDIR', '/secioss/share/simplesamlphp');
    define('SAMLLDAPCONF', SAMLDIR.'/config/ldap.php');
    define('OPENIDCONF', '/secioss/share/samopenid/conf/config.ini');
    define('LISMCONF', '/secioss/etc/lism.conf');
    define('LISMSVRCONF', '/secioss/etc/lism-server.conf');
    define('LISMRELOAD', 'perl /secioss/sbin/lismconfig reload > nul');
    define('LISMSYNC', 'perl /secioss/sbin/lismsync');
}

define("S_INTERNAL_ERR_MSG", "内部エラーが発生しました。");
define("S_AUTHENTICATION_ERR_MSG", "ユーザIDまたはパスワードが違います。");
define("S_INVALID_INPUT_VALUE_MSG", "入力された値が不正です。");
define("C_ALREADY_EXISTS_MSG", "既に登録されています。");
define("C_UPDATE_SUCCESS_MSG", "正常に保存されました。");
define("C_UPDATE_ERR_MSG", "保存に失敗しました。");
define("C_DELETE_SUCCESS_MSG", "正常に削除されました。");
define("C_DELETE_ERR_MSG", "削除に失敗しました。");
define("C_RELOAD_ERR_MSG", "設定の再読み込みに失敗しました。");
define("C_FILEOPEN_ERR_MSG", "ファイルを開けません。");
define("C_FILEWRITE_ERR_MSG", "ファイルに書き込めません。");
define("C_LDAP_CONFIG_ERR_MSG", "設定を正しく行ってください。");
define("O_ADD_SUCCESS_MSG", "正常に登録されました。");
define("O_ADD_ERR_MSG", "登録に失敗しました。");
define("O_UPDATE_SUCCESS_MSG", "正常に変更されました。");
define("O_UPDATE_ERR_MSG", "変更に失敗しました。");
define("O_DELETE_SUCCESS_MSG", "正常に削除されました。");
define("O_DELETE_ERR_MSG", "削除に失敗しました。");
define("O_INITPASSWD_SUCCESS_MSG", "パスワードが正常に初期化されました。");
define("O_INITPASSWD_ERR_MSG", "パスワードの初期化に失敗しました。");
define("O_SENDMAIL_ERR_MSG", "メールの送信に失敗しました。");
define("O_ALREADY_EXISTS_MSG", "既に登録されています。");
define("O_NO_SUCH_OBJECT_MSG", "存在しません。");
define("O_SYNC_SUCCESS_MSG", "正常に同期されました。");

require_once('util.php');

// {{{ Secioss_ActionClass
/**
 *  action実行クラス
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @access     public
 */
class Secioss_ActionClass extends Ethna_ActionClass
{
    /**
     *  アクション実行前の認証処理を行う
     *
     *  @access public
     *  @return string  遷移名(nullなら正常終了, falseなら処理終了)
     */
    function authenticate()
    {
        if ( !$this->session->isStart() ) {
            if (get_class($this) != 'Secioss_Action_Index') {
                $this->redirect('index.php?action_timeout=true');
                return null;
            }

            if (isset($_SERVER['REMOTE_USER'])) {
                $this->af->setApp('authtype', 'sso');
            }

            return 'login';
        }
    }

    /**
     *  アクション実行前の処理(フォーム値チェック等)を行う
     *
     *  @access public
     *  @return string  遷移名(nullなら正常終了, falseなら処理終了)
     */
    function prepare()
    {
        return parent::prepare();
    }

    /**
     *  アクション実行
     *
     *  @access public
     *  @return string  遷移名(nullなら遷移は行わない)
     */
    function perform()
    {
        return parent::perform();
    }

    function getErrorFormName()
    {
        $error_list = $this->ae->getErrorList();
        return $error_list[0]['name'];
    }

    function getInvalidValMsg($name)
    {
        $form_name = $this->af->getName($name);
        return $form_name.'に'.S_INVALID_INPUT_VALUE_MSG;
    }

    function redirect($url)
    {
        print("<html>
<head>
<title>Secioss Administrator</title>
<script language=\"javascript\"><!--
function clearFrame()
{
    top.location.href = \"$url\";
}
// --></script>
</head>
<body onload=\"clearFrame()\">
</body>
</html>");
    }
}
// }}}
?>
