<?php
$path = ini_get('include_path');
$path =  dirname(__FILE__) . PATH_SEPARATOR . $path;
ini_set('include_path', $path);

require_once("Log.php");

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

function logformat($message)
{
    $ipaddr = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '-';
    $user = isset($_SESSION['username']) ? $_SESSION['username'] : '-';

    return "$ipaddr $user $message";
}

?>
