package LISM::Handler::Setval;

use strict;
use base qw(LISM::Handler);
use Sys::Syslog;
use Sys::Syslog qw(:macros);
use Data::Dumper;

=head1 NAME

LISM::Handler::Setval - Handler to set value

=head1 DESCRIPTION

This class implements the L<LISM::Hanlder> interface to set value.

=head1 METHODS

=pod

=head2 getOrder

Get order to do handler.

=cut

sub getOrder
{
    return 'first';
}

=head2 pre_add($dnp, $entryStrp)

Set Value before add operation is done.

=cut

sub pre_add
{
    my $self = shift;
    my ($dnp, $entryStrp) = @_;
    my $conf = $self->{_config};

    if (!defined($conf->{entry})) {
        return 0;
    }

    foreach my $entry (@{$conf->{entry}}) {
        if (defined($entry->{dn}) && ${$dnp} !~ /$entry->{dn}/i) {
            next;
        }

        # Default value
        if (defined($entry->{default})) {
            foreach my $attr (keys %{$entry->{default}}) {
                if (${$entryStrp}[0] !~ /^$attr:/mi) {
                    my @values = $self->_getStaticValue($entry->{default}{$attr}, ${$dnp}, ${$entryStrp}[0]);
                    foreach my $value (@values) {
                        ${$entryStrp}[0] = "${$entryStrp}[0]$attr: $value\n";
                    }
                }
            }
        }

        # Add values
        if (defined($entry->{addition})) {
            foreach my $attr (keys %{$entry->{addition}}) {
                my @values = $self->_getStaticValue($entry->{addition}{$attr}, ${$dnp}, ${$entryStrp}[0]);
                foreach my $value (@values) {
                    if (${$entryStrp}[0] !~ /^$attr:{1,2} $value/mi) {
                        ${$entryStrp}[0] = "${$entryStrp}[0]$attr: $value\n";
                    }
                }
            }
        }
    }

    return 0;
}

sub _checkConfig
{
    my $self = shift;
    my $conf = $self->{_config};
    my $rc = 0;

    if ($rc = $self->SUPER::_checkConfig()) {
        return $rc;
    }

    if (defined($conf->{libload})) {
        foreach my $lib (@{$conf->{libload}}) {
            eval "do \'$lib\'";
            if ($@) {
                $self->log(level => 'alert', message => "setval do require $lib: $@");
                return 1;
            }
        }
    }

    return $rc;
}

sub _getStaticValue
{
    my $self = shift;
    my ($static, $dn, $entryStr) = @_;
    my @values;

    # get static value
    if (defined($static->{value})) {
        for (my $i = 0; $i < @{$static->{value}}; $i++) {
            my $value;

            if ($static->{value}[0]->{type} eq 'function') {
                eval "\$value = $static->{value}[0]->{content}";
                if ($@) {
                    $self->log(level => 'error', message => "setval $static->{value}[0]->{content} failed: $@");
                }
            } else {
                $value = $static->{value}[0]->{content};
            }

            if ($value) {
                push(@values, $value);
            }
        }
    }

    return @values;
}

=head1 SEE ALSO

L<LISM>,
L<LISM::Handler>

=head1 AUTHOR

Kaoru Sekiguchi, <sekiguchi.kaoru@secioss.co.jp>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Kaoru Sekiguchi

This library is free software; you can redistribute it and/or modify
it under the GNU LGPL.

=cut

1;
