#!/bin/bash

MARCO_PACKAGE_VARIANT_USERDEBUG="userdebug"
MARCO_PACKAGE_VARIANT_FACTORY="eng"
MARCO_PACKAGE_VARIANT_USER="user"
EVB_NAME="EVB"
SR_NAME="SR"
FB="./fastboot "

get_package_info()
{
	if [ -n "$1" ] ;then
		val=$(cat build_info | grep $1 | tr -d ' ' | cut -d'=' -f2)
		echo -n $val
	fi
}

get_project_name()
{
	pro_name=$(sudo $FB getvar product 2>&1 | grep product | awk '{print $2}')
	echo -n $pro_name
}

get_stage_id()
{
	stage_id=$(sudo $FB getvar stage-id 2>&1 | grep stage-id | awk '{print $2}')
	echo -n $stage_id
}

get_package_project_name()
{
	package_project=$(cat build_info | grep TARGET_PRODUCT | tr -d ' ' | cut -d'=' -f2)
	echo -n $package_project
}

download_fail()
{
    echo "..."
    echo "Update image failed"
    echo "Finally, If there is any problem after running err_handle,You Can contact BSP Project Team for help"
    echo ====================
    echo Download failed
    echo ====================
    exit 1
}

# ======================= update fastboot cmd ==================================
FB1=""
if [ "$1" != "" ];then
    FB1="-s ""$1"
fi
FB=${FB}${FB1}
echo check fastboot cmd
sudo $FB getvar product
if [ $? != 0 ]; then
    FB="./fastboot "
    sudo $FB getvar product
    if [ $? != 0 ]; then
        echo Usage ./update_image.sh [SSN_NUM]
        download_fail
    fi
fi
echo fastbot cmd : $FB
# ======================= end update fastboot cmd ===============================

if [ -z $PACKAGE_VARIANT ];then
	PACKAGE_VARIANT=$(get_package_info TARGET_BUILD_VARIANT)
fi

if [ -z $PROJECT_VERSION ];then
	PROJECT_VERSION1=$(get_package_info PROJECT_BUILD_VERSION | awk -F '.' '{print $1}')
    PROJECT_VERSION2=$(get_package_info PROJECT_BUILD_VERSION | awk -F '.' '{print $2}')
    PROJECT_VERSION3=$(get_package_info PROJECT_BUILD_VERSION | awk -F '.' '{print $3}')
    PROJECT_VERSION4=$(get_package_info PROJECT_BUILD_VERSION | awk -F '.' '{print $4}')
fi

PACKAGE_TARGET_SKU=$(get_package_info TARGET_SKU)
PROJECT_NAME=$(get_project_name)
STAGE_ID=$(get_stage_id)
IMAGE_PROJECT_NAME=$(get_package_project_name)

echo "================================================"
echo "package version: $PACKAGE_VARIANT"
echo "project name:    $PROJECT_NAME"
echo "stage id:        $STAGE_ID"
echo "package sku:     $PACKAGE_TARGET_SKU"
echo "================================================"

if [ "$1" == "oneslot" ];then
    echo "flash only slot A"
fi

PROJECT_CMP=$(echo $PROJECT_NAME | grep "$IMAGE_PROJECT_NAME")
if [ "$PROJECT_CMP" == "" ]; then
    echo "This image is for ZS620KL, make sure you use the right image!"
    echo "Finally, If there is still any problem,You Can contact BSP Project Team for help"
    download_fail
fi

result1=$(echo $STAGE_ID | grep "${EVB_NAME}")
result2=$(echo $STAGE_ID | grep "${SR_NAME}")
result=${result1}${result2}
#if [ "$result" == "" ]&&[ "$PROJECT_VERSION1" -le "80" ]&&[ "$PROJECT_VERSION2" -le "1" ]&&[ "$PROJECT_VERSION3" -le "2" ]&&[ "$PROJECT_VERSION4" -le "86" ]; then
#    echo "Image is too old, please update"
#    echo "You Can contact BSP Project Team for help"
#	download_fail
#fi

echo "flash image now"
echo "================================================"

function GetProject()
{
	#sudo $FB getvar project 2>&1 | grep "project" | grep -q "ZS620KL"
	if [ $? -eq 0 ]; then
		project=ZS620KL
	fi
	project=ZS620KL
	#sudo $FB getvar project 2>&1
}

GetProject

if [ -n "$project" ]; then
	echo Current project type is $project
else
	echo "cannot get project!!!error!!!"
	download_fail
fi 

# ======================= flash: abl ==================================
echo "Start Flash abl"
sudo $FB flash abl_a fac_abl.elf
if [ $? != 0 ]; then
    download_fail
fi
sudo $FB flash abl_b fac_abl.elf
if [ $? != 0 ]; then
    download_fail
fi

# =================================================================
echo ====================
echo "Download Complete !"
echo ====================
echo Press any key to continue, system will reboot to bootloader.
read
sudo $FB reboot bootloader
