// CuŜŋp萔EϐE֐

#include <iostream>
#include <cstdlib>
#include <cmath>
#include "lilib.h"

using namespace lilib;

const int lilib::LIMB_BITS = 32;			// 1 limb ̃rbg
const int lilib::LIMBS_MIN = 3;				// limbs ̍ŏl
const double lilib::DOUBLE_0x100000000 = 0x100000000LL;	// 0x100000000

int lilib::limbs = 0;					// { limbs AݒԂ 0

// 64 rbg̏ 32 rbg
uint32_t lilib::high32(uint64_t x){
  return x >> LIMB_BITS;
}

// 64 rbg̉ 32 rbg
uint32_t lilib::low32(uint64_t x){
  return x & 0xffffffff;
}

// 64 rbg̐K
int lilib::normalize64(uint64_t *x){
  int e;

  // ŏʃrbg 1 ɂȂ܂ōɃVtgB
  e = 0;
  if(*x){
    while(!(*x & 0x8000000000000000LL)){
      *x <<= 1;
      e++;
    }
  }

  // VtgrbgԂB
  return e;
}

// {̐x̐ݒ
void lilib::setPrecision(int precision){

  // ̊֐͈xĂׂȂ
  if(limbs){
    std::cerr << "[ERROR] lilib::setPrecision(int precision) : This function must be called only once." << std::endl;
    exit(1);
  }

  if(precision < 0){
    std::cerr << "[ERROR] lilib::setPrecision(int precision) : precision must be positive." << std::endl;
    exit(1);
  }

  // limbs = static_cast<int>(ceil(log(10) / LIMB_BITS / log(2) * precision)) + 1;
  limbs = static_cast<int>(ceil(0.10381025296523007337 * precision)) + 1;
  if(limbs < LIMBS_MIN){
    limbs = LIMBS_MIN;
  }
}

// {̐x̎擾Aݒ̂Ƃ 0 Ԃ
int lilib::getPrecision(){

  // ݒ̂Ƃ 0 Ԃ
  if(limbs < LIMBS_MIN){
    return 0;
  }

  // return static_cast<int>(LIMB_BITS * log10(2) * (limbs - 1));
  return static_cast<int>(9.6329598612473982468 * (limbs - 1));
}
