﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/
Shader "Euclid/EuclidClippingModelShader"
{
	Properties{
		_MainTex("Base (RGB)", 2D) = "white" {}
		_Color("Main Color", Color) = (1,1,1,1)

		_BlendSrcColor("Blend Src Color", int) = 0
		_BlendDstColor("Blend Dst Color", int) = 0
		_BlendSrcAlpha("Blend Src Alpha", int) = 0
		_BlendDstAlpha("Blend Dst Alpha", int) = 0

		_StencilRef2("StencilRef2", int) = 2
	}
	SubShader{
		Tags {
			"Queue" = "Transparent"
			"IgnoreProjector" = "True"
			"RenderType" = "Transparent"
			"PreviewType" = "Plane"
		}

		Cull Off
		Blend [_BlendSrcColor][_BlendDstColor],[_BlendSrcAlpha][_BlendDstAlpha]
		ZWrite Off
		Lighting Off

		Pass{
			Stencil{
				Ref [_StencilRef2]
				Comp Equal
				Pass Zero
				Fail Zero
			}

			CGPROGRAM

			#pragma vertex vert
			#pragma fragment frag

			#include "UnityCG.cginc"
			#include "EuclidCG.cginc"

			fixed4 _Color;
			sampler2D _MainTex;

			struct v2f {
				float4 pos : SV_POSITION;
				float2 uv : TEXCOORD0;
			};

			float4 _MainTex_ST;

			v2f vert(appdata_base v)
			{
				v2f o;
				o.pos = UnityObjectToClipPos(v.vertex);
				o.pos = EuclidMeshTransform(o.pos);
				o.uv = TRANSFORM_TEX(v.texcoord, _MainTex);
				return o;
			}

			fixed4 frag(v2f i) : SV_TARGET
			{
				fixed4 texcol = tex2D(_MainTex, i.uv);
				texcol.a *= _Color.a;
				texcol.rgb *= texcol.a; // pre-multiplied
				return texcol;
			}

			ENDCG
		}
	}

	Fallback "VertexLit"
}
