﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/
Shader "Euclid/EuclidClippingBaseShader"
{
	Properties{
		_StencilRef1("StencilRef1", int) = 1
	}
	SubShader{
		Tags {
			"Queue" = "Transparent"
			"IgnoreProjector" = "True"
			"RenderType" = "Transparent"
		}

		Cull Off
		Blend Off
		ZWrite Off
		Lighting Off
		ColorMask 0

		Pass{
			Stencil{
				Ref [_StencilRef1]
				Comp Always
				Pass Replace
			}

			CGPROGRAM

			#pragma vertex vert
			#pragma fragment frag

			#include "UnityCG.cginc"
			#include "EuclidCG.cginc"

			float4 vert(float4 vertex : POSITION) : SV_POSITION
			{
				float4 pos = UnityObjectToClipPos(vertex);
				return EuclidMeshTransform(pos);
			}

			fixed4 frag(float4 pos : SV_POSITION) : SV_TARGET
			{
				// DO NOTHING
				return 1;
			}

			ENDCG
		}
	}

	Fallback "VertexLit"
}
