﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

using System.Collections.Generic;
using UnityEngine;

namespace live2d.Mecanim
{
    [AddComponentMenu("")]
    public class ModelParameters : MonoBehaviour
    {
        public List<EuclidModel> Target;

        public void SetAt(string parameterName, float value)
        {
            // Fail silently.
            if (string.IsNullOrEmpty(parameterName))
            {
                return;
            }

            if (parameterName.StartsWith("PARAM_JOINT_"))
                return;

            for (var i = 0; i < Target.Count; i++)
            {
                if (Target[i] == null) continue;
                Target[i].setParameterValue(parameterName, value);
            }

        }
    }
}
