﻿/*
*Copyright(c) Live2D Inc. All rights reserved.
*このソースコードの使用には、"http://www.live2d.com/eula/live2d-open-software-license-agreement_jp.html"ファイルにあるLive2D Open Software ライセンスが適用されます。
*Use of this source code is governed by a Live2D Open Software license that can be found in the "http://www.live2d.com/eula/live2d-open-software-license-agreement_en.html" file.
*/

using System;
using UnityEditor;
using UnityEngine;

namespace live2d.Mecanim.EditorExtensions
{
    public sealed class AnimationClipGenerator
    {
        private FrameByFrameSampler _keyframeSampler = new FrameByFrameSampler();

        private Mtn _mtn;

        private Type _parametersType;

        #region Setters

        public AnimationClipGenerator SetMtn(Mtn mtn)
        {
            _mtn = mtn;


            return this;
        }

        public AnimationClipGenerator SetParametersType(Type parametersType)
        {
            _parametersType = parametersType;


            return this;
        }

        #endregion

        #region Generation

        public AnimationClip GenerateAnimationClip()
        {
            var animationClip = new AnimationClip();


            var fps = _mtn.Fps;
            var duration = _mtn.Duration;
            var parametersClass = _parametersType;


            // Create parameter curves.
            foreach (var curve in _mtn.ParameterCurves)
            {
                var sampler = _keyframeSampler;
                var animationCurve = new AnimationCurve();
                
                foreach (var keyframe in sampler.SampleFrames(curve.Values, fps))
                {
                    animationCurve.AddKey(keyframe);
                }


                animationClip.SetCurve(string.Empty, parametersClass, curve.ParameterName, animationCurve);
            }


            // Set the duration.
            var animationClipSettings = new AnimationClipSettings
            {
                stopTime = duration
            };


            AnimationUtility.SetAnimationClipSettings(animationClip, animationClipSettings);


            return animationClip;
        }

        #endregion
    }
}