/*

    libftp 1.0 (stable): this is an FTP library to simplify the work to a Developer
    who want to work with FTP servers (RFC 959).
    Copyright (C) 2007/2008  omnipresent - omnipresent[at]email.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>

*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>

#include "ftp_main.h"
/* Struct sockaddr_in for the connections of the transfers way */
struct sockaddr_in ftp_connection;

/*** 
     ftp_connect:
     - char *host           => HostName/IP
     - int port             => Port to connect to
     - struct sockaddr_in * => pointer to sockaddr_in structure
     - int verbose          => Verbose?
     . 0 Do not Print
     . 1 Print
     - ret                  => Success?
     . sock Socket Descriptor Returned
     .-1 Error
***/


int ftp_connect(char *host, int port, struct sockaddr_in *ftp_server, int verbose)
{
    struct hostent *he;
    int sock;
    struct timeval tm; //tv_sec - tv_usec
    fd_set readfds;
    char buf[1024];
    int n;

    
    if ( (he=gethostbyname(host)) == NULL) {
	
	if (verbose) {
	
	    if (h_errno == HOST_NOT_FOUND) {
		printf("[-] Host Not Found!\n");
		printf("exiting..\n");
		return(HOST_NOT_FOUND);

	    } else if (h_errno == TRY_AGAIN) {
		printf("[-] Temporary error.. Try Again!\n");
		printf("exiting..\n");
		return(TRY_AGAIN);

	    } else if (h_errno == NO_RECOVERY) {
		printf("[-] Unexpected Server Error!\n");
		printf("exiting..\n");
		return(NO_RECOVERY);

	    } else if (h_errno == NO_DATA) {
		printf("[-] HostName has not IP Address!\n");
		printf("exiting..\n");
		return(NO_DATA);

	    }

	} else {

	    if (h_errno == HOST_NOT_FOUND) {
		return(HOST_NOT_FOUND);

	    } else if (h_errno == TRY_AGAIN) {
		return(TRY_AGAIN);

	    } else if (h_errno == NO_RECOVERY) {
		return(NO_RECOVERY);

	    } else if (h_errno == NO_DATA) {
		return(NO_DATA);

	    }

	}

	return -1;

    }

    memset(ftp_server,0,sizeof(ftp_server));
    ftp_server->sin_port = htons(port);
    ftp_server->sin_family = AF_INET;
	
    memcpy ((char *)&ftp_server->sin_addr,he->h_addr,he->h_length);

	
    ftp_connection.sin_family = AF_INET;
    memcpy ((char *)&ftp_connection.sin_addr, he->h_addr,he->h_length);

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {

	if (verbose) {
	    perror("Socket");
	}

	return -1;
    }

    sleep(1);
    if (connect(sock, (struct sockaddr *)ftp_server, sizeof(struct sockaddr)) != 0)  {
	if (verbose) {
	    perror("connect()");
	}
	return -1;
    }

    if (verbose) {
	printf("[ Connected ]\n");
    }
	

    buf[1023] = '\0';
    FD_ZERO(&readfds);

    tm.tv_sec = 3;
    tm.tv_usec = 0;

    FD_SET(sock, &readfds);
    sleep(1); //wait the banner..

    if (select(sock+1, &readfds, NULL, NULL, &tm) < 0 ) {
	if (verbose) {
	    perror("select()");
	}
	return -1;
    } else {

	if (FD_ISSET(sock, &readfds)) {
	    if ( (n = recv(sock, buf, 1022, 0)) < 0)  {
		if (verbose) {
		    perror("recv()");
		}
		return -1;
	    }
	    buf[n] = '\0';

	    if (verbose) {
		printf("[Server] %s\n", buf);
	    }
	}
	else {
	    if (verbose)
		printf("[-] Timeout\n");
			
	    return -1;
	}
    }


    return sock; //Socket Descriptor returned!!
}

