/**
 * log4js[0.9.1]
 * (c) 2007 Shigehito funaki <funaki@sourceforge.jp>
 * 
 * <quick start>
 * 1.include js.
 *   <script src='/js/log4.js' type='text/javascript'></script>
 * 2.configure
 *   LogConfig.add({
 *	     category : 'test',
 *	     level    : LOG_LEVEL.INFO
 *       });
 * 3.create logger
 *   var logger = LoggerFactory.create("test.category");
 * 4.print
 *   logger.error("error message");
 *   //...methods fatal,error,warn,info,debug
 */
 
/** Ox萔 */
var LOG_LEVEL = {
  FATAL   : 1,
  ERROR   : 2,
  WARN    : 3,
  INFO    : 4,
  DEBUG   : 5
};

/** OݒRNVIuWFNg */
var LogConfig = {
  size : function() {
    return this.list.length;
  },
  list  : new Array(),
  get : function(index) {
    return this.list[index];
  },
  add : function(config) {
    if (!config.appender) {
        config.appender = {
            obj      : Appender.consoleFloat,
            holdSize : 99,
            order    : 'desc'};
    }
    this.list[this.size()] = config;
  }
};

/** K[t@Ng */
var LoggerFactory = {
  create: function(category) {
    return new Logger(category);
  }
};

/** K[NX */
function Logger(category) {
	this.category = category;
};
Logger.prototype = {
  fatal  : function(msg) {this.log(LOG_LEVEL.FATAL, msg);},
  error  : function(msg) {this.log(LOG_LEVEL.ERROR, msg);},
  warn   : function(msg) {this.log(LOG_LEVEL.WARN , msg);},
  info   : function(msg) {this.log(LOG_LEVEL.INFO , msg);},
  debug  : function(msg) {this.log(LOG_LEVEL.DEBUG, msg);},
  log    : function(level, msg) {
    for (var i = 0; i < LogConfig.size(); i++) {
      var config = LogConfig.get(i);

      if (config.category) {
        var chk = this.category.substring(0, config.category.length);
        if (chk != config.category) continue;				
//if (this.category.indexOf(config.category) != 0) continue;
      }
      if (config.level < level) continue;
      if (!config.appender) continue;
      config.appender.obj.write(config.appender, level, this.now(), msg);
    }
  },
  now : function() {
    var d = new Date();
    return this.format(d.getHours(), "00") + ":" +
            this.format(d.getMinutes(), "00") + ":" +
            this.format(d.getSeconds(), "00");
  },
  format : function(val, formatString) {
    var tmp = formatString + val;
    return tmp.substring(tmp.length - formatString.length);
 }
};

var Layout = {
  dump : function(obj) {
    if (obj) {
      var msg = "";
      for (var o in obj) {
        msg += o + "={" + obj[o] + "} ";
      }
      return msg;
    } else {
      return 'undefined';
    }
  }
};



/** hLgDIVŕ\R\[Ay_ */
var InsideConsoleAppender = {
  createTableBody : function(doc) {
    var win = doc.createElement('DIV');
    win.setAttribute('id', 'log4jsDialog');
    
    var header = doc.createElement('DIV');
    header.setAttribute('id', 'log4jsDialog_header');
    var c1 = doc.createElement('span');
    var title = doc.createTextNode("log4js console");
    c1.appendChild(title);
    header.appendChild(c1);
    var ocBtn = doc.createElement('span');
    ocBtn.appendChild(doc.createTextNode("[hide]"));
    Element.setStyle(ocBtn, {cursor: 'pointer'});
    Event.observe(ocBtn, 'mousedown', this._clickOpenClose.bind(this), false);
    header.appendChild(ocBtn);
    
    var body = doc.createElement('DIV');
    body.setAttribute('id', 'log4jsDialog_body');
    var table = doc.createElement('TABLE');
    var tb = doc.createElement('TBODY');
    table.appendChild(tb);	
    body.appendChild(table);
    
    var resizer = doc.createElement('DIV');
    resizer.setAttribute('id', 'log4jsDialog_rezier');
    
    win.appendChild(header);
    win.appendChild(body);
    win.appendChild(resizer);

    Element.setStyle(win,		this.style.win);
    Element.setStyle(header,	this.style.header);
    Element.setStyle(body,		this.style.body);
    Element.setStyle(resizer,	this.style.resizer);
    
    Element.setStyle(header,	this.style.font);
    Element.setStyle(body,		this.style.font);
    Element.setStyle(resizer,	this.style.font);
    
    win.style['width']			= this.style.windowWidth  + "px";
    win.style['height']			= this.style.windowHeight + "px";
    header.style['height']		= this.style.headerHeight + "px";
    body.style['height']		= this.style.windowHeight - this.style.headerHeight - this.style.footerHeight + "px";
    resizer.style['height']		= this.style.footerHeight + "px";

    var b = doc.getElementsByTagName('BODY')[0];
    if (b) {
      b.appendChild(win);
      this.setEventHandler();
    }

    this._openClose(this.style.startWithHide);

    return tb;
  },
  _clickOpenClose: function(e) {
    this._openClose(Element.visible($('log4jsDialog_body')));
    Event.stop(e);
  },
  _openClose: function(show) {
    var objwin  = $('log4jsDialog');
    var objBody = $('log4jsDialog_body');
    var objfoot = $('log4jsDialog_rezier');

    var txt = "";
    if (show) {
      this.width  = Element.getStyle(objwin, 'width');
      this.height = Element.getStyle(objwin, 'height');
      Element.setStyle(objwin, {width: '140px', height: '19px'});

      Element.hide(objBody);
      Element.hide(objfoot);
      txt = "[show]";
    } else {
      Element.setStyle(objwin, {width: this.width, height: this.height});

      Element.show(objBody);
      Element.show(objfoot);
      txt = "[hide]";
    }
    $('log4jsDialog_header').lastChild.innerHTML = txt;
  },
  
  _createObj: function(val, leftDepth) {
    if (!val || leftDepth <= 0) {
        return document.createElement('span');
    }
      
    var ret;
    if (typeof(val) == "function") {
      ret = document.createElement('span');
      ret.appendChild(document.createTextNode("function"));
      ret.appendChild(document.createElement('br'));       
    } else if (typeof(val) == "object") {
      ret = document.createElement('span');
      
      var a = document.createElement('span');
      Element.setStyle(a, {cursor: 'pointer'});
      a.appendChild(document.createTextNode("[+]"));
      if (a.addEventListener) {
        a.addEventListener('mousedown', this._objectClick.bind(a), false);
      } else if (a.attachEvent) {
        a.attachEvent('onmousedown', this._objectClick.bind(a));
      }
      ret.appendChild(a);

      var div = document.createElement('span');
      Element.setStyle(div, {display: 'none', paddingLeft: '16px'});
      ret.appendChild(div);

      try {
        for (p in val) {
          var nm = document.createElement('div');
          nm.appendChild(document.createTextNode(p + ":"));
          var child = this._createObj(val[p], leftDepth - 1);
          nm.appendChild(child);
          div.appendChild(nm);
        }
      } catch (e) {
        alert("log4js error:" + e);
        return document.createElement('span');
      }
    } else {
      ret = document.createElement('span');
      ret.appendChild(document.createTextNode(val));
      ret.appendChild(document.createElement('br'));
    }
    return ret;
  },
  _objectClick:function() {
    var o = this.parentNode.lastChild;
    var s = !Element.visible(o);
    var d = s ? 'block' : 'none';
    Element.setStyle(o, {display: d});
    this.innerHTML=(s) ? '[-]' : '[+]';
  },
  write : function(config, level, ts, msg) {
    if (!this.tableBody) {
      this.tableBody = this.createTableBody(document);
    }
    
    var msgObj = this._createObj(msg, this.style.maxDepth);
    
    var tr = document.createElement('TR');
    var h1 = document.createElement('TD');
    h1.setAttribute("wrap", "false");
    var t1 = document.createTextNode("[" + level + "]");
    h1.appendChild(t1);
    tr.appendChild(h1);
    var h2 = document.createElement('TD');
    h2.setAttribute("wrap", "false");
    var t2 = document.createTextNode(ts);
    h2.appendChild(t2);
    tr.appendChild(h2);
    var h3 = document.createElement('TD');
    h3.setAttribute("wrap", "false");
//    var t3 = document.createTextNode(msg);
    h3.appendChild(msgObj);
    tr.appendChild(h3);
    
    Element.setStyle(h1, this.style.font);		
    Element.setStyle(h2, this.style.font);
    Element.setStyle(h3, this.style.font);

    var target = this.tableBody;
    var cut = (config.holdSize <= target.childNodes.length);
    if (config.order.toLowerCase() == "desc") {
      target.insertBefore(tr, target.firstChild);
      if (cut) {
        target.removeChild(target.lastChild);
      }
    } else {
      target.appendChild(tr);
      if (cut) {
        target.removeChild(target.firstChild);
      }
    }
  },
  
  setEventHandler : function() {
    Event.observe(document,        'mouseup',   this.mouseup, false);
    Event.observe(document,        'mousemove', this.mousemove, false);
    Event.observe('log4jsDialog_header', 'mousedown', this.dialogTitleClicked, false);
    Event.observe('log4jsDialog_rezier', 'mousedown', this.dialogResizeClicked, false);
  },
  
  sx : 0,
  sy : 0,
  wx : 0,
  wy : 0,
  dragging  : false,
  resizeing : false,
  activeWin : null,
  
  dialogTitleClicked : function(e) {
    var ap = InsideConsoleAppender;
    ap.activeWin	= $('log4jsDialog');
    
    ap.sx = Event.pointerX(e);
    ap.sy = Event.pointerY(e);
    ap.wx = Element.getStyle(ap.activeWin, 'left');
    ap.wy = Element.getStyle(ap.activeWin, 'top');
    ap.wx = new Number(ap.wx.substring(0, ap.wx.length - 2));
    ap.wy = new Number(ap.wy.substring(0, ap.wy.length - 2));
    
    ap.dragging = true;
    Element.setStyle(ap.activeWin, {borderColor: 'red'});
  },
  
  dialogResizeClicked : function(e) {
    var ap = InsideConsoleAppender;
    ap.activeWin	= $('log4jsDialog');
    
    ap.sx = Event.pointerX(e);
    ap.sy = Event.pointerY(e);
    ap.wx = Element.getStyle(ap.activeWin, 'left');
    ap.wy = Element.getStyle(ap.activeWin, 'top');
    ap.wx = new Number(ap.wx.substring(0, ap.wx.length - 2));
    ap.wy = new Number(ap.wy.substring(0, ap.wy.length - 2));
    	
    ap.resizing = true;
    Element.setStyle(ap.activeWin, {borderColor: 'red'});
  },

  mousemove : function(e) {
    var ap = InsideConsoleAppender;

    if (ap.dragging) {
      var x = Event.pointerX(e);
      var y = Event.pointerY(e);
      Event.stop(e);
      var mx = (x - ap.sx + ap.wx) + "px";
      var my = (y - ap.sy + ap.wy) + "px";
      Element.setStyle(ap.activeWin, {top: my,left: mx});

    } else if (ap.resizing) {
      var x = Event.pointerX(e);
      var y = Event.pointerY(e);
      Event.stop(e);
      var w = (x - ap.wx) + "px";
      var h = (y - ap.wy) + "px";
      var h2 = (y - ap.wy - ap.style.headerHeight - ap.style.footerHeight) + "px";
      Element.setStyle(ap.activeWin, {width: w,height: h});
      Element.setStyle("log4jsDialog_body", {height: h2});
    }
  },
  mouseup : function(e) {
    var ap = InsideConsoleAppender;

    ap.dragging	= false;
    ap.resizing	= false;
    if (ap.activeWin) {
      Element.setStyle(ap.activeWin, {borderColor: '#666666'});
    }
    ap.activeWin = null;
  },
  closeDialog : function() {
    Element.hide('log4jsDialog');
  },
  style: {
    maxDepth     : 3,      /** object^WJő[B傫Ɩcȏ\zIȂȂBRȉ𐄏 */
    startWithHide: true,   /** true:\ɕ  */
    windowWidth  : 300,    /** EChEʒu */
    windowHeight : 260,    /** EChEʒu */
    headerHeight : 16,     /** EChEʒu */
    footerHeight : 12,     /** EChEʒu */
    win: {
      position       : "absolute",
      top            : "0px",
      left           : "0px",
      borderStyle    : "solid",
      borderWidth    : "1px",
      borderColor    : "#666666"
    },
    header: {
      color          : "#eeeeee",
      backgroundColor: "#666666",
      width          : "100%",
      cursor         : "move"
    },
    body: {
      color          : "#333333",
      backgroundColor: "#dddddd",
      width          : "100%",
      overflow       : "scroll",
      filter         : 'alpha(opacity=75)',
      opacity        : '0.75'	
    },
    resizer: {
      color          : "#333333",
      backgroundColor: "#aaaaaa",
      width          : "100%",
      cursor         : "nw-resize"
    },
    font: {
      fontFamily     : "lr SVbN",/* "MS UI Gothic"*/
      fontSize       : "9pt"
    }		
  }
};

/** [gփO擾vsAy_(php̂ݎ) */
var ReomteAppender = {
  cache      : "",
  cacheCount : 0,
  write : function(config, level, ts, msg) {	
    this.cache += ts + "\t" + msg;
    this.cacheCount++;
    var sz = config.cacheSize;
    if (this.cacheCount >= sz) {
      param = "mode=" + level + "&msg=" + encodeURIComponent(msg);
      new Ajax.Request(config.uri, {method: 'get', parameters: param});
      this.cache = "";
      this.cacheCount = 0;
    } else {
      this.cache += "\r\n";
    }
  }
};

/** Ay_̃V[gJbg */
var Appender = {
  console      : InsideConsoleAppender,
  consoleFloat : InsideConsoleAppender,
  remote       : ReomteAppender
};

