package jp.co.lax.sample.service.dao;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.lax.sample.service.TaskPaper;

import org.apache.log4j.Logger;

/**
 * AjaxpDAONXB t@CFTaskBoardDao.java
 * 
 * @author ^Y 쐬F9:59:33
 * 
 */
public class TaskBoardDao extends BaseDao {

	private Logger log = Logger.getLogger(TaskBoardDao.class);

	/**
	 * Task̏ԂXVB
	 * 
	 * @param taskId
	 * @param status
	 */
	public void updateTask(final long taskId, final String taskTitle,
			final String taskAuthor, final long status) {
		try {
			super.initConnection();
			PreparedStatement statement = super.connection
					.prepareStatement("UPDATE TaskTable SET taskTitle=?, status=?,author=? WHERE id =?");
			statement.setString(1, taskTitle);
			statement.setLong(2, status);
			statement.setString(3, taskAuthor);
			statement.setLong(4, taskId);
			if (!statement.execute()) {

			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}
	}

	public void addTask(final String taskTitle, final String taskAuthor,
			final long status) {
		long nextId = this.getNextTaskId();
		try {
			super.initConnection();
			PreparedStatement statement = super.connection
					.prepareStatement("INSERT INTO TaskTable (id,taskTitle,status,author) VALUES(?,?,?,?)");
			statement.setLong(1, nextId);
			statement.setString(2, taskTitle);
			statement.setLong(3, status);
			statement.setString(4, taskAuthor);
			if (!statement.execute()) {

			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}
	}

	public void deleteAllTask() {
		try {
			super.initConnection();

			PreparedStatement statement = super.connection
					.prepareStatement("DELETE FROM TaskTable ");

			if (!statement.execute()) {

			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}

	}

	public void deleteTaskById(final long taskId) {
		try {
			super.initConnection();

			PreparedStatement statement = super.connection
					.prepareStatement("DELETE FROM TaskTable WHERE id =?");
			statement.setLong(1, taskId);
			if (!statement.execute()) {

			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}

	}

	private long getNextTaskId() {
		try {
			super.initConnection();

			PreparedStatement statement = super.connection
					.prepareStatement("SELECT MAX(id) as id FROM TaskTable ");

			ResultSet result = statement.executeQuery();
			while (result.next()) {
				return result.getLong("id") + 1;
			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}
		return 0;
	}

	public List findTaskList() {
		List<TaskPaper> list = new ArrayList<TaskPaper>();
		try {
			super.initConnection();

			PreparedStatement statement = super.connection
					.prepareStatement("SELECT * FROM TaskTable ");

			ResultSet result = statement.executeQuery();

			while (result.next()) {
				TaskPaper paper = new TaskPaper();
				// paper̓eZbg
				paper.setId(result.getInt("id"));
				paper.setTitle(result.getString("taskTitle"));
				paper.setAuthor(result.getString("author"));
				paper.setStatus(result.getInt("status"));
				list.add(paper);
			}
		} catch (IOException e) {

			e.printStackTrace();
		} catch (SQLException e) {

			e.printStackTrace();
		}
		return list;
	}

	/**
	 * Task̏ԂXVB
	 * 
	 * @param taskId
	 * @param status
	 */
	public TaskPaper findByPrimaryKey(final long taskId) {
		try {
			super.initConnection();
			PreparedStatement statement = super.connection
					.prepareStatement("SELECT * FROM TaskTable WHERE id =?");
			statement.setLong(1, taskId);
			ResultSet result = statement.executeQuery();
			log.info("findTaskById id:" + taskId);
			TaskPaper paper = new TaskPaper();
			while (result.next()) {
				// paper̓eZbg
				log.info("PAPER SET");
				paper.setId(result.getInt("id"));
				paper.setTitle(result.getString("taskTitle"));
				paper.setAuthor(result.getString("author"));
				paper.setStatus(result.getInt("status"));
			}
			return paper;
		} catch (IOException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			log.error("findTaskById ERROR:" + e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

}
