package jp.co.cybec.laxide.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import jp.co.cybec.laxide.util.LetsAjaxWizardUtil;
import lax.LetsAjaxActivator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/**
 * VKLAXt@C쐬EBU[hNX.
 * <p>
 * VKLAX쐬́uEBU[hʁ|Pv𐶐EǗNXłB<br>
 * EBU[hʂ̊eEBWFbgA̓tB[h̏ݒs܂B
 * </p>
 * 
 * @author katoh
 */
public class LetsAjaxNewWizard extends Wizard implements INewWizard {

	/**  */
	private IStructuredSelection selection_;

	/** VKt@C쐬EBU[hy[W */
	private LetsAjaxNewWizardPage pageNewFile;

	/**
	 * RXgN^.
	 */
	public LetsAjaxNewWizard() {

		super();
		setNeedsProgressMonitor(true);
		setWindowTitle("LAXt@C̐VK쐬");
	}

	/**
	 * .
	 * 
	 * @param workbench
	 * @param selection
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench,
	 *      IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {

		selection_ = selection;
	}

	/**
	 * [NXy[XɃEBU[hIuWFNgݒ肵܂.
	 * 
	 * <p>
	 * EBU[h𐶐āAEclipsẽ[NXy[Xɏo͂܂B
	 * </p>
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages() {

		// -------------------------------------------
		// ǂݍ݌t@C擾EBU[hy[W
		// -------------------------------------------

		// y[W
		pageNewFile = new LetsAjaxNewWizardPage(LetsAjaxNewWizardPage.PAGE_ID,
				selection_);
		// y[W^Cgݒ
		pageNewFile.setTitle("VKLAXt@C");
		// y[Wݒ
		pageNewFile.setDescription("VKLXAt@C쐬܂B");
		// VK쐬t@C̃ftHg̐ݒ
		pageNewFile.setFileName("sample.lax");
		// EBWFbgReiɊi[
		addPage(this.pageNewFile);
	}

	/**
	 * I{^픻.
	 * 
	 * <p>
	 * I{^ꂽꍇ̃of[V܂B
	 * </p>
	 * 
	 * @return boolean t@C쐬Ăꍇ<code>true</code>AłȂꍇ<code>false</code>Ԃ܂
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {

		// t@C쐬
		IFile file = pageNewFile.createNewFile();

		// 쐬ʂNull̏ꍇ̓G[
		if (file == null) {
			return false;
		}
		//LetsAjaxNewWizardPage wizard = (LetsAjaxNewWizardPage) getPage(LetsAjaxNewWizardPage.PAGE_ID);

		try {
			
			// t@Co͂
			File newLaxfile = new File(file.getProject().getLocation().toString()
					+ "/" + file.getProjectRelativePath());
			newLaxfile.createNewFile();

			InputStream stream = new FileInputStream(newLaxfile);

			file.create(stream, true, null);

			// ANeBuRg[̕ύX
			IWorkbenchPage page = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			// 쐬t@CGfB^[ŊJ
			IDE.openEditor(page, file, true);
			
			LetsAjaxWizardUtil util = new LetsAjaxWizardUtil();
			util.initLaxDataToFile(newLaxfile);
			
		} catch (PartInitException piex) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"LAXt@CVK쐬G[", piex));
			piex.printStackTrace();
			return false;
		} catch (Exception e) {
			// 
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"LAXt@CVK쐬G[", e));
			e.printStackTrace();
			return false;
		}

		return true;
	}
}