package jp.co.cybec.laxide.model.js;

import jp.co.cybec.laxide.model.base.AbstractModel;

import org.eclipse.draw2d.geometry.Rectangle;

/**
 * JavaScriptɑ郂f̋KNX t@CFJSBaseModel.java
 * 
 * @author nakamura 쐬F10:20:31
 * 
 */
public class JSBaseModel extends AbstractModel {
	// ύX̎ނʂ邽߂̕
	public static final String P_CONSTRAINT = "_constraint";

	protected Rectangle constraint; // 

	// f̑
	private String type;

	private String id;

	private String x;

	private String y;

	public Rectangle getConstraint() {
		return constraint;
	}

	public void setConstraint(Rectangle rect) {
		constraint = rect;
		if (this.constraint != null) {
			this.setX(Integer.toString(this.constraint.x));
			this.setY(Integer.toString(this.constraint.y));
		}
		// ύX̒ʒm
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	// XMLt@Cւ̕ۑ
	public String getLayoutXML() {
		String html = "<" + this.type + this.getId() + getBodyComponentXml()
				+ " x=\"" + this.x + "\" y=\"" + this.y + "\" />\n";
		return html;
	}

	/**
	 * @return id
	 */
	public String getId() {
		if (id == null || (id != null && id.equals(""))) {
			return "";
		}
		return " id=\"" + this.id + "\" ";
	}

	public void setId(final String id) {
		this.id = id;
	}

	/**
	 * @return type
	 */
	public String getType() {
		return this.type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return "";
	}

	/**
	 * @return x
	 */
	public String getX() {
		return x;
	}

	/**
	 * @param x
	 *            x ݒB
	 */
	public void setX(String x) {
		this.x = x;
	}

	/**
	 * @return y
	 */
	public String getY() {
		return y;
	}

	/**
	 * @param y
	 *            y ݒB
	 */
	public void setY(String y) {
		this.y = y;
	}
}
