/**
 * vWFNg laxIde
 * NX YuiBasicAnimateModel.java
 * 쐬: 2007/06/07
 * 
 */
package jp.co.cybec.laxide.model.extension;

import jp.co.cybec.laxide.model.base.BaseModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * YahooUIAj[VpfNX t@CFYuiBasicAnimateModel.java
 * 
 * @author nakamura 쐬F15:32:10
 * 
 */
public class YuiBasicAnimateModel extends BaseModel {

	public static final String P_TARGET_ID = "_targetId";

	private String targetId = "targetId";

	private static final int HEIGHT = 80;

	private static final int WIDTH = 180;

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] { new TextPropertyDescriptor(
				P_TARGET_ID, "^[QbgR|[lg") };
		return descriptors;

	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_TARGET_ID)) {
			return this.targetId;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_TARGET_ID))
			return true;
		else
			return false;
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_TARGET_ID)) {
			setTargetId((String) value);
		}
	}

	public void setConstraint(Rectangle rect) {
		super.constraint = rect;
		if (super.constraint != null) {
			this.setX(Integer.toString(super.constraint.x));
			this.setY(Integer.toString(super.constraint.y));
			super.constraint.height = HEIGHT;
			super.constraint.width = WIDTH;
		}

		// ύX̒ʒm
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getTargetForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_YUI_ANIMATE);

		String targetId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_TARGETID);
		setTargetId(targetId);
	}

	private String getTargetForXml() {
		if (targetId == null || (targetId != null && targetId.equals(""))) {
			return "";
		}
		return " targetId=\"" + this.targetId + "\" ";
	}

	/**
	 * @return targetId
	 */
	public String getTargetId() {
		return targetId;
	}

	/**
	 * @param targetId
	 *            targetId ݒB
	 */
	public void setTargetId(String targetId) {
		this.targetId = targetId;
		firePropertyChange(P_TARGET_ID, null, targetId);
	}
}
