package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * WI{^̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxRadioButtonModel extends BaseModel {
	private String name = "radio button";

	public static final String P_NAME = "_name";

	private String value;

	public static final String P_VALUE = "_value";

	private String componentWidth = "80";

	private String componentHeight = "20";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = {"", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getNameForXml();
		html = html + getValueForXml();
		html = html + getComponetWidthForXml();
		html = html + getComponetHeightForXml();
		html = html + getCssClassNameForXml();
		html = html + getEventForXml() + getDataSourceIdForXml();
		return html;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_RADIOBUTTON);

		this
				.setName(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME));
		this
				.setValue(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE));
		this.componentWidth = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_WIDTH);

		this.componentHeight = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_HEIGHT);
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		
		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);
		
		super.setCssClassName(cssClass);
		setDataSourceId(dataSourceId);
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * WI{^ݒ肵܂
	 * 
	 * @param value WI{^
	 */
	public void setName(String value) {
		this.name = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_NAME, null, this.name);
	}

	/**
	 * WI{^Ԃ܂
	 * 
	 * @return WI{^
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃WI{^Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃WI{^ 
	 */
	private String getNameForXml() {
		if (this.name == null || (this.name != null && this.name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	/**
	 * WI{^Valuelݒ肵܂
	 * 
	 * @param value WI{^Valuel
	 */
	public void setValue(String value) {
		this.value = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_VALUE, null, this.value);
	}

	/**
	 * WI{^ValuelԂ܂
	 * 
	 * @return WI{^Valuel
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂ValuelԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂Valuel
	 */
	private String getValueForXml() {
		if (this.value == null || (this.value != null && this.value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\" ";
	}

	/**
	 * i̕Ԃ܂
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂
	 * 
	 * @param width i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̕Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\""
					+ Integer.toString(this.value.length() * 5) + "\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * i̍Ԃ܂
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param componentHeight i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̍Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_NAME, ""),
				new TextPropertyDescriptor(P_VALUE, "l"),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(super.P_ID)) {
			return super.id;
		} else if (id.equals(P_NAME)) {
			return name;
		} else if (id.equals(P_VALUE)) {
			return value;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME) || id.equals(P_VALUE) || id.equals(P_EVENT)
				|| id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_VALUE)) {
			setValue((String) value);
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			super.setCssClassName((String) value);
		}
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, dataSourceId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃f[^\[XIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃f[^\[XID 
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * ,laxɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
