package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * ÑfNX
 * 
 * @author tokumaru
 */
public class LetsAjaxLinkButtonModel extends BaseModel {
	private String url = "../";

	public static final String P_URL = "_url";

	private String text = "value";

	public static final String P_TEXT = "_text";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String componentWidth = "60";

	private String componentHeight = "20";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = { "", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getUrlForXml();
		html = html + getValueForXml();
		html = html + getComponetWidthForXml() + getComponetHeightForXml();
		html = html + getCssClassNameForXml();
		html = html + getEventForXml() + getDataSourceIdForXml();
		return html;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_LINKBUTTON);
		this
				.setUrl(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_URL));
		this
				.setText(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_TEXT));
		
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		String csscCass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);
		
		setCssClassName(csscCass);
		setDataSourceId(dataSourceId);
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * URLݒ肵܂
	 * 
	 * @param value URL
	 */
	public void setUrl(String value) {
		this.url = value;
		firePropertyChange(P_URL, null, value);
	}

	/**
	 * URLԂ܂
	 * 
	 * @return URL
	 */
	public String getUrl() {
		return this.url;
	}

	/**
	 * .laxt@Cɐݒ肷URLԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷URL 
	 */
	private String getUrlForXml() {
		if (this.url == null || (this.url != null && this.url.equals(""))) {
			return "";
		}
		return " url=\"" + this.url + "\" ";
	}

	/**
	 * ÑeLXgݒ肵܂
	 * 
	 * @param value ÑeLXg
	 */
	public void setText(String value) {
		this.text = value;
		firePropertyChange(P_TEXT, null, value);
	}

	/**
	 * ÑeLXgԂ܂
	 * 
	 * @return ÑeLXg
	 */
	public String getText() {
		return this.text;
	}

	/**
	 * .laxɐݒ肷eLXgԂ܂
	 * 
	 * @return .laxɐݒ肷eLXg
	 */
	private String getValueForXml() {
		if (this.text == null || (this.text != null && this.text.equals(""))) {
			return "";
		}
		return " text=\"" + this.text + "\" ";
	}

	/**
	 * i̕Ԃ܂
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂
	 * 
	 * @param width i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxɐݒ肷镔i̕Ԃ܂
	 * 
	 * @return .laxɐݒ肷镔i̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\""
					+ Integer.toString(this.text.length() * 5) + "\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * i̍Ԃ܂
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param componentHeight i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/**
	 * .laxt@Cɐݒ肷镔i̍Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷镔i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_URL, "N"),
				new TextPropertyDescriptor(P_TEXT, "l"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(super.P_ID)) {
			return super.id;
		}
		if (id.equals(P_URL)) {
			return url;
		} else if (id.equals(P_TEXT)) {
			return text;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_URL) || id.equals(P_TEXT) || id.equals(P_EVENT)
				|| id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_URL)) {
			setUrl((String) value);
		} else if (id.equals(P_TEXT)) {
			setText((String) value);
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, dataSourceId);
	}

	/**
	 * .laxt@Cɐݒ肷f[^\[XIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxt@Cɐݒ肷CxgIDԂ܂
	 * 
	 * @return CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
