package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * chart ̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxChartModel extends BaseModel {
	private String width = "100";

	private String height = "80";

	private int graphTypeId = 1;

	public static final String P_WIDTH = "_width";

	public static final String P_HIGHT = "_hight";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	public static final String P_CHART_TYPE = "_chartType";

	public static final String VERTICAL_BAR_CHART = "VerticalBarChart";

	public static final String HORIZONTAL_BAR_CHART = "HorizontalBarChart";

	public static final String LINE_CHART = "LineChart";

	public static final String PIE_CHART = "PieChart";

	private String dataSourceId = "dataSourceId";

	private String chartTypes[] = { VERTICAL_BAR_CHART, HORIZONTAL_BAR_CHART,
			LINE_CHART, PIE_CHART };

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getChartTypeForXml();
		html = html + getHeightForXml();
		html = html + getWidthForXml();
		html = html + getDataSourceIdForXml();
		return html;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		String id = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ID);
		super.setId(id);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_JS_CHART);
		setWidth(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_WIDTH));
		setHeight(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_HEIGHT));
		setConstraint(new Rectangle(Integer.parseInt(super.getX()), Integer
				.parseInt(super.getY()), Integer.parseInt(getWidth()), Integer
				.parseInt(getHeight())));
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		setDataSourceId(dataSourceId);
		String chartType = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CHART_TYPE);
		setChartType(1);
		for (int i = 0; i < chartTypes.length; i++) {
			if (chartType != null && chartType.equals(chartTypes[i])) {
				setChartType(i + 1);
				break;
			}
		}
	}

	/**
	 * Heightݒ肵܂
	 * 
	 * @param value
	 *            Height
	 */
	public void setHeight(String value) {
		this.height = value;

		if (getConstraint() != null) {
			// RRŐɍݒ肷邱Ƃɂă}EXł̑傫ύXsɂĂ
			getConstraint().height = Integer.parseInt(this.height);
		}

		firePropertyChange(P_HIGHT, null, value);
	}

	/**
	 * HeightlԂ܂
	 * 
	 * @return Heightl
	 */
	public String getHeight() {
		return this.height;
	}

	/**
	 * .laxt@Cɐݒ肷colslԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷colsl
	 */
	private String getHeightForXml() {
		if (this.height == null
				|| (this.height != null && this.height.equals(""))) {
			return "";
		}
		return LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_HEIGHT
				+ "=\"" + this.height + "\" ";
	}

	/**
	 * Widthlݒ肵܂
	 * 
	 * @param value
	 *            Widthl
	 */
	public void setWidth(String value) {
		this.width = value;

		if (getConstraint() != null) {
			// RRŐɍݒ肷邱Ƃɂă}EXł̑傫ύXsɂĂ
			getConstraint().width = Integer.parseInt(this.width);
		}

		firePropertyChange(P_WIDTH, null, value);
	}

	/**
	 * WidthlԂ܂
	 * 
	 * @return Widthl
	 */
	public String getWidth() {
		return this.width;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂rowslԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂rowsl
	 */
	private String getWidthForXml() {
		if (this.width == null || (this.width != null && this.width.equals(""))) {
			return "";
		}
		return LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_WIDTH
				+ "=\"" + this.width + "\" ";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "f[^\[XID"),
				new TextPropertyDescriptor(P_WIDTH, ""),
				new TextPropertyDescriptor(P_HIGHT, ""),
				new ComboBoxPropertyDescriptor(P_CHART_TYPE, "`[g^Cv" ,chartTypes)};
		return descriptors;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_ID)) {
			return super.id;
		} else if (id.equals(P_HIGHT)) {
			return this.height;
		} else if (id.equals(P_WIDTH)) {
			return this.width;
		} else if (id.equals(P_CHART_TYPE)) {
			return new Integer(this.graphTypeId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_ID)) {
			return true;
		} else if (id.equals(P_HIGHT)) {
			return true;
		} else if (id.equals(P_WIDTH)) {
			return true;
		} else if (id.equals(P_CHART_TYPE)) {
			return true;
		} else if (id.equals(P_DATASOURCE_ID)) {
			return true;
		} else {
			return false;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_HIGHT)) {
			setHeight(LetsAjaxUtil.getDigitValue(this.height, (String) value));
		} else if (id.equals(P_WIDTH)) {
			setWidth(LetsAjaxUtil.getDigitValue(this.width, (String) value));
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CHART_TYPE)) {
			setChartType(((Integer) value).intValue() + 1);
		} else if (id.equals(P_ID)) {
			setId((String) value);
		}
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId
	 *            f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, dataSourceId);
	}

	/**
	 * .laxɐݒ肷邽߂̃f[^\[XIDԂ܂
	 * 
	 * @return .laxɐݒ肷邽߂̃f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * chartTypeԂ܂
	 * 
	 * @return graphType
	 */
	public int getChartType() {
		return graphTypeId;
	}

	/**
	 * chartTypeݒ肵܂
	 * 
	 * @param chartType
	 *            Ot^Cv
	 */
	public void setChartType(int chartType) {
		this.graphTypeId = chartType;
		firePropertyChange(P_CHART_TYPE, null, chartType);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃CxgID
	 */
	private String getChartTypeForXml() {
		return " chartType=\"" + chartTypes[graphTypeId - 1] + "\" ";
	}
	
	public String getChartTypeString(int index) {
		return chartTypes[index - 1];
	}
}
