package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * {^̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxButtonModel extends BaseModel {

	public static final String P_VALUE = "_value";

	public static final String P_NAME = "_name";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String name = "Button";

	private String value = "Button1";

	private String componentWidth = "60";

	private String componentHeight = "20";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = { "", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/**
	 * {^Ԃ܂B
	 * 
	 * @return {^
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * .laxt@Cɏo͂邽߂̃{^Ԃ܂
	 * 
	 * @return .laxɏo͂邽߂̃{^
	 */
	private String getNameForXml() {
		if (name == null || (name != null && name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	/**
	 * {^ݒ肵܂
	 * 
	 * @param name@{^
	 */
	public void setName(String name) {
		this.name = LetsAjaxUtil.checkNull(name);
		firePropertyChange(P_NAME, null, this.name);
	}

	/**
	 * valuelԂ܂
	 * 
	 * @return value
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɏo͂邽߂valueԂ܂.
	 * 
	 * @return value .laxt@Cɏo͂邽߂value
	 */
	private String getValueForXml() {
		if (value == null || (value != null && value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\"";
	}

	/**
	 * valuelݒ肵܂
	 * 
	 * @param value
	 */
	public void setValue(String value) {
		this.value = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_VALUE, null, this.value);
	}

	/**
	 * i̕擾܂
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param width
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɏo͂邽߂̕Ԃ܂
	 * 
	 * @return .laxt@Cɏo͂邽߂̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\""
					+ Integer.toString(this.value.length() * 5) + "\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * i̍Ԃ܂
	 * 
	 * @return@i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param componentHeight@i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/**
	 * .laxt@Cɏo͂邽߂̕i̍Ԃ܂
	 * 
	 * @return
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_VALUE, "VALUE"),
				new TextPropertyDescriptor(P_NAME, "NAME"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		
		return descriptors;

	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_ID)) {
			return super.id;
		} else if (id.equals(P_VALUE)) {
			return value;
		} else if (id.equals(P_NAME)) {
			return name;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return super.getCssClassName();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_VALUE) || id.equals(P_NAME) || id.equals(P_EVENT)
				|| id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_VALUE)) {
			setValue((String) value);
		} else if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return this.getNameForXml() + this.getValueForXml()
				+ this.getComponetWidthForXml()
				+ this.getComponetHeightForXml()
				+ this.getCssClassNameForXml()
				+ this.getEventForXml()
				+ this.getDataSourceIdForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_BUTTON);
		String name = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME);
		String value = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE);
		
		this.setName(name);
		this.setValue(value);
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		setDataSourceId(dataSourceId);

		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);
		super.setCssClassName(cssClass);
		
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId
	 *            dataSourceId ݒB
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		
		firePropertyChange(P_DATASOURCE_ID, null, this.dataSourceId);
	}

	/**
	 * .laxɏo͂邽߂̃f[^\[XIDԂ܂
	 * 
	 * @return
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂
	 * 
	 * @return event
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event
	 *            event ݒB
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃CxgIDio[Ԃ܂
	 * 
	 * @return CxgIDio[
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
