package jp.co.cybec.laxide.model.base;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * BodyfNXB t@CFLetsAjaxBodyModel.java
 * 
 * @author nakamura 쐬F14:56:10
 * 
 */
public class LetsAjaxBodyModel extends BaseModel {

	// qf̒ǉ͍폜ɂč\ωƂ
	public static final String P_CHILDREN = "_children";

	private List children = new ArrayList(); // qf̃Xg

	public static final String P_TITLE = "_title";

	public static final String P_BGCOLOR = "_BGCOLOR";

	public static final String P_ONLOAD = "_onLoad";

	private String title = "LET'S AJAX";

	private String bgColor = "#FFFFFF";

	/** J[pbhRGBl */
	private int red, green, blue;

	private String onLoad = "init();";

	public void addChild(Object child) {

		if (children.size() != 0 && child instanceof I_LetsAjaxLayoutModel) {
			if (children.get(0) instanceof I_LetsAjaxLayoutModel) {
				children.remove(0);
			}
			children.add(0, child); // qf(CAEgf)ǉ
		} else {
			children.add(child); // qfǉ
		}

		// EditPartւ̒ʒm
		firePropertyChange(P_CHILDREN, null, null);
	}

	public List getChildren() {
		return children; // qfԂ
	}

	public void removeChild(Object child) {
		// qf̍폜
		children.remove(child);
		// EditPartւ̒ʒm
		firePropertyChange(P_CHILDREN, null, null);
	}

	// TODO 
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_TITLE, "^Cg"),
				new TextPropertyDescriptor(super.P_CLASS_NAME, "CSSNX"),
				new ColorPropertyDescriptor(P_BGCOLOR, "wiF"),
				new TextPropertyDescriptor(P_ONLOAD, "ʃ[h̏") };
		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_BGCOLOR)) {
			return new RGB(red, green, blue);
		} else if (id.equals(P_ONLOAD)) {
			return this.onLoad;
		} else if (id.equals(P_TITLE)) {
			return this.title;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_BGCOLOR) || id.equals(P_ONLOAD) || id.equals(P_TITLE)) {
			return true;
		} else {
			return false;
		}
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_BGCOLOR)) {
			setBgColor((RGB) value);
		} else if (id.equals(P_ONLOAD)) {
			setOnLoad((String) value);
		} else if (id.equals(P_TITLE)) {
			setTitle((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getLayoutXML()
	 */
	@Override
	public String getLayoutXML() {
		return "<" + this.getType() + this.getId() + getBodyComponentXml()
				+ ">\n";
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return this.getBgColorForXml() + this.getOnLoadForXml()
				+ this.getTitleForXml();
	}

	/**
	 * @return bgColor
	 */
	private String getBgColorForXml() {
		if (this.bgColor == null
				|| (this.bgColor != null && this.bgColor.equals(""))) {
			return "";
		}
		return " bgColor=\"" + this.bgColor + "\"";
	}

	/**
	 * @return bgColor
	 */
	public String getBgColor() {
		return this.bgColor;
	}

	/**
	 * @param bgColor
	 *            bgColor ݒB
	 */
	public void setBgColor(RGB rgb) {
		red = ((RGB) rgb).red;
		green = ((RGB) rgb).green;
		blue = ((RGB) rgb).blue;

		this.bgColor = "#" + Integer.toString(red, 16)
				+ Integer.toString(green, 16) + Integer.toString(blue, 16);

		// J[pbh̕ύXEditPartɒʒm
		firePropertyChange(P_BGCOLOR, null, bgColor);
	}

	/**
	 * @return script
	 */
	private String getOnLoadForXml() {
		if (this.onLoad == null
				|| (this.onLoad != null && this.onLoad.equals(""))) {
			return "";
		}
		return " onLoad=\"" + this.onLoad + "\"";
	}

	/**
	 * @return script
	 */
	public String getOnLoad() {
		return this.onLoad;
	}

	/**
	 * @param onLoad
	 *            Onload ݒB
	 */
	public void setOnLoad(String onLoad) {
		this.onLoad = onLoad;
		firePropertyChange(P_ONLOAD, null, onLoad);
	}

	public int getChildCount() {
		return this.children.size();
	}

	/**
	 * @return title
	 */
	private String getTitleForXml() {
		if (this.onLoad == null
				|| (this.title != null && this.title.equals(""))) {
			return "";
		}
		return " title=\"" + this.title + "\"";
	}

	/**
	 * @return title
	 */
	public String getTitle() {
		return this.title;
	}

	/**
	 * @param title
	 *            title ݒB
	 */
	public void setTitle(String title) {
		this.title = title;
		firePropertyChange(P_TITLE, null, title);
	}
}
