package jp.co.cybec.laxide.model.base;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jdom.Element;

/**
 * fNX̒ۃNX
 * 
 * @author tokumaru
 */
public abstract class AbstractModel implements IPropertySource {

	public abstract void setId(String id);

	public abstract String getId();

	public abstract void setType(String type);

	public abstract String getType();

	public abstract Rectangle getConstraint();

	public abstract void setConstraint(Rectangle rect);

	/** ȋ傫̎ݒ */
	private static int AOUTO_SIZE_SETTING = -1;

	/**
	 * XĩXg
	 */
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	/**
	 * Xi̒ǉ
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		listeners.addPropertyChangeListener(listener);
	}

	/**
	 * f̕ύXʒm
	 * 
	 * @param propName
	 * @param oldValue
	 * @param newValue
	 */
	public void firePropertyChange(String propName, Object oldValue,
			Object newValue) {

		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	/**
	 * Xi̍폜
	 * 
	 * @param listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		listeners.removePropertyChangeListener(listener);
	}

	public Object getEditableValue() {
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[0];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
	 */
	public void resetPropertyValue(Object id) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
	}

	/**
	 * fɑlZbgB ł͊efɋʂĂ鍀ڂZbgĂB
	 * 
	 * @param element
	 */
	public void setAttribute(Element element) {
		String id = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ID);

		String positoinX = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_X);
		int x = 0;
		if (positoinX != null) {
			x = Integer.parseInt(positoinX);
		}

		String positionY = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_Y);
		int y = 0;
		if (positionY != null) {
			y = Integer.parseInt(positionY);
		}
		
		String height = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_HEIGHT);
		int componentHeight = AOUTO_SIZE_SETTING;
		if (height != null && !height.equals("")) {
			componentHeight = Integer.parseInt(height);
		}

		String width = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_WIDTH);
		int componentWidth = AOUTO_SIZE_SETTING;
		if (width != null && !width.equals("")) {
			componentWidth = Integer.parseInt(width);
		}

		setId(id);
		setConstraint(new Rectangle(x, y, componentWidth, componentHeight));
	}

	/**
	 * laxt@CɃCAEgo͂B
	 * 
	 * @return
	 */
	public abstract String getLayoutXML();

	/**
	 * .laxt@CɕۑsۂɌĂяoA̕iɐݒ肳ꂽl Ԃ܂B
	 * 
	 * @return iɐݒ肳ꂽl
	 */
	public abstract String getBodyComponentXml();

}
