package jp.co.cybec.laxide.layout;

import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

/**
 * CAEg`̂߂̍W񋟂NX
 * 
 * 
 * @author tokumaru
 */
public abstract class AbstractLayoutPoints {
	private static final int LINE_WIDTH = 1;
	public static final double REAL_ZIZE_RATE = 1.6; 
	
    /**
     * fUCiɃCAEg`悷邽߂PointListNXԂ܂B
     * 
     * @return PointListNX
     */
    public abstract PointList getPointList();
    
    /**
     * CAEg̃wb_[̈̃X^[g|CgԂ܂B
     * CAEgɃwb_[ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getHeaderStartPoint();
    
    /**
     * CAEg̃wb_[̈̃X^[g|CgԂ܂B
     * CAEgɃwb_[ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getHeaderEndPoint();
    
    /**
     * CAEg̃tb^[̈̃X^[g|CgԂ܂B
     * CAEgɃtb^[ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getFooterStartPoint();
    
    /**
     * CAEg̃tb^[̈̃X^[g|CgԂ܂B
     * CAEgɃtb^[ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getFooterEndPoint();
    
    /**
     * CAEg̃Rec̈̃X^[g|CgԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getContentsStartPoint();
    
    /**
     * CAEg̃Rec̈̃X^[g|CgԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getContentsEndPoint();
    
    /**
     * CAEg̗̍̈̃X^[g|CgԂ܂B
     * CAEgɍ̗̈悪ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getSideLeftStartPoint();
    
    /**
     * CAEg̗̍̈̃X^[g|CgԂ܂B
     * CAEgɍ̗̈悪ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getSideLeftEndPoint();
    
    /**
     * CAEg̉Ë̗̃X^[g|CgԂ܂B
     * CAEgɉË̗悪ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getSideRightStartPoint();
    
    /**
     * CAEg̉Ë̗̃X^[g|CgԂ܂B
     * CAEgɉË̗悪ȂꍇnullԂ܂B
     * 
     * @return PointNX
     */
    public abstract Point getSideRightEndPoint();
    
    /**
     * CAEg̃C`悷邽߂PolyLineIuWFNgԂ܂B
     * 
     * @return Polyline
     */
    public Polyline getLayoutPolyLine() {
    	PointList points = getPointList();
    	Polyline line = new Polyline();
    	line.setPoints(points);
    	line.setLineWidth(LINE_WIDTH);
    	
    	return line;
    }
}
