package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxTextFieldModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * eLXgtB[h`悷NX. t@CFLetsAjaxTextFieldEditPart.java
 * 
 * @author nakamura 쐬F13:54:36
 * 
 */
public class LetsAjaxTextFieldEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ύXꂽɌĂ΂郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxTextFieldModel.P_CONSTRAINT)) {
			LetsAjaxTextFieldModel model = (LetsAjaxTextFieldModel) getModel();
			Label label = (Label) getFigure();

			model.setSize(Integer.toString(label.getSize().width));
			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName().equals(LetsAjaxTextFieldModel.P_VALUE)) {
			// f̕ύXr[ɕ\
			Label label = (Label) getFigure();
			label.setText((String) evt.getNewValue());
		} else if (evt.getPropertyName().equals(LetsAjaxTextFieldModel.P_SIZE)) {
			// f̕ύXr[ɕ\
			Label label = (Label) getFigure();
			label.setSize(Integer.parseInt((String) evt.getNewValue()), 20);
			label.setBorder(new LineBorder());
		}
	}

	/**
	 * eLXgtB[h̐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxTextFieldModel model = (LetsAjaxTextFieldModel) getModel();

		Label label = new Label();
		label.setText(model.getValue());
		// wiFs
		label.setOpaque(false);
		label.setSize(Integer.parseInt(model.getSize()), 20);
		label.setBorder(new LineBorder());
		return label;
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxTextFieldModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}

}
