package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxLabelModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * x`悷NX t@CFLetsAjaxLabelEditPart.java
 * 
 * @author nakamura 쐬F13:39:16
 * 
 */
public class LetsAjaxLabelEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ύXꂽɌĂ΂郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		LetsAjaxLabelModel model = (LetsAjaxLabelModel) getModel();
		Label label = (Label) getFigure();

		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxLabelModel.P_CONSTRAINT)) {
			int textWidth = label.getTextBounds().width;
			label.getSize().width = textWidth;

			model.getConstraint().width = textWidth;
			model.getConstraint().height = 20;
			model.setComponentWidth(String.valueOf(textWidth));
			model.setComponentHeight("20");

			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName().equals(LetsAjaxLabelModel.P_VALUE)) {
			// f̃eLXgύXꂽ̂Ńr[ɕ\eLXgXV
			label.setText((String) evt.getNewValue());

			int newTextWidth = label.getTextBounds().width;
			label.getSize().width = newTextWidth;

			model.getConstraint().width = newTextWidth;
			model.setComponentWidth(String.valueOf(newTextWidth));
		}
	}

	/**
	 * x̐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxLabelModel model = (LetsAjaxLabelModel) getModel();

		Label label = new Label();
		label.setText(model.getValue());

		// wiFs
		label.setOpaque(true);
		label.setSize(60, 50);
		return label;
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxLabelModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}
}
