package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;
import java.io.File;

import jp.co.cybec.laxide.LetsAjaxEditor;
import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxImageModel;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;

/**
 * C[W`悷NX t@CFLetsAjaxImageEditPart.java
 * 
 * @author nakamura 쐬F13:33:02
 * 
 */
public class LetsAjaxImageEditPart extends EditPartWithListener {

	private DirectEditManager directManager = null;

	/**
	 * ύXꂽɌĂ΂郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {

		if (evt.getPropertyName().equals(LetsAjaxImageModel.P_CONSTRAINT)) {
			refreshVisuals();
		} else if (evt.getPropertyName().equals(LetsAjaxImageModel.P_FILE)) {
			ImageFigure figure = (ImageFigure) getFigure();
			String fileName = (String) evt.getNewValue();

			if (checkFileExist(fileName)) {
				figure.setImage(new Image(null, fileName));
			} else {
				figure.setImage(new Image(null, LetsAjaxEditor.class.getClass()
						.getResourceAsStream("image.gif")));
			}

			refreshVisuals();
		}
	}

	/**
	 * C[Wt@C[Jɑ݂邩`FbNB
	 * 
	 * @param fileName
	 * @return
	 */
	private boolean checkFileExist(String fileName) {
		File file = new File(fileName);
		return file.isFile();
	}

	/**
	 * C[W̐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		Image img = null;
		LetsAjaxImageModel model = (LetsAjaxImageModel) getModel();

		if (checkFileExist(model.getFile())) {
			img = new Image(null, model.getFile());
		} else {
			img = new Image(null, LetsAjaxEditor.class
					.getResourceAsStream("image.gif"));
		}

		ImageFigure figure = new ImageFigure();
		figure.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(
				3)));
		figure.setSize(60, 50);
		figure.setImage(img);
		return figure;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		Rectangle constraint = ((LetsAjaxImageModel) getModel())
				.getConstraint();

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show();
	}

}
