package jp.co.cybec.laxide;

import java.io.File;

import jp.co.cybec.laxide.editParts.LetsAjaxBodyEditPart;
import jp.co.cybec.laxide.editParts.LetsAjaxEditPartFactory;
import jp.co.cybec.laxide.file.LetsAjaxLayoutFileManager;
import jp.co.cybec.laxide.model.base.LetsAjax2ColumnHeaderLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjax2ColumnLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjaxBodyModel;
import jp.co.cybec.laxide.model.base.LetsAjaxButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxChartModel;
import jp.co.cybec.laxide.model.base.LetsAjaxCheckBoxModel;
import jp.co.cybec.laxide.model.base.LetsAjaxComboBoxModel;
import jp.co.cybec.laxide.model.base.LetsAjaxImageModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLabelModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;
import jp.co.cybec.laxide.model.base.LetsAjaxLinkButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxPlainLayoutModel;
import jp.co.cybec.laxide.model.base.LetsAjaxRadioButtonModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextAreaModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextFieldModel;
import jp.co.cybec.laxide.model.base.LetsAjaxTextModel;
import jp.co.cybec.laxide.model.extension.LetsAjaxDataTableModel;
import jp.co.cybec.laxide.model.extension.YuiBasicAnimateModel;
import jp.co.cybec.laxide.model.extension.YuiCalendarModel;
import jp.co.cybec.laxide.model.js.YuiColorAnimateJSModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class LetsAjaxEditor extends GraphicalEditorWithPalette {
	/*
	 * r[łB
	 */
	private GraphicalViewer laxView;

	/**
	 * RXgN^
	 * 
	 */
	public LetsAjaxEditor() {
		setEditDomain(new DefaultEditDomain(this));
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		// getActivePage()null̏ꍇ͖
		if (part.getSite().getWorkbenchWindow().getActivePage() == null)
			return;
		super.selectionChanged(part, selection);
	}

	/**
	 * pbgɕi\Ă
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditorWithPalette#getPaletteRoot()
	 */
	protected PaletteRoot getPaletteRoot() {
		// pbg̃[g
		PaletteRoot root = new PaletteRoot();

		// f쐬ȊÕc[i[O[v
		PaletteGroup toolGroup = new PaletteGroup("c[");

		// 'I' c[̍쐬ƒǉ
		ToolEntry tool = new SelectionToolEntry();
		toolGroup.add(tool);
		root.setDefaultEntry(tool); // ftHgŃANeBuɂȂc[

		// '͂ݘg' c[̍쐬ƒǉ
		tool = new MarqueeToolEntry();
		toolGroup.add(tool);

		// 쐬O[v[gɒǉ
		root.add(toolGroup);
		root.add(this.getBaseComponentGroup());
		root.add(this.getOtherComponentGroup());
		root.add(this.getServiceComponentGroup());
		root.add(this.getJSComponentGroup());
		root.add(this.getLauoutTemplateGroup());
		return root;
	}

	/**
	 * pbgւ̊{izu
	 * 
	 * @return
	 */
	private PaletteDrawer getBaseComponentGroup() {
		// f̍쐬sc[i[O[v
		PaletteDrawer drawer = new PaletteDrawer("{i");

		// 쐬ƒǉ
		ImageDescriptor textDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "text.gif");
		CreationToolEntry creationTextEntry = new CreationToolEntry("eLXg", // pbgɕ\镶
				"TEXT", // c[`bv
				new SimpleFactory(LetsAjaxTextModel.class), // f쐬t@Ng
				textDescriptor, // pbgɕ\16X16̃C[W
				textDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(creationTextEntry);

		// LABEL쐬ƒǉ
		ImageDescriptor descriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "label.gif");
		CreationToolEntry creationEntry = new CreationToolEntry("x", // pbgɕ\镶
				"LABEL", // c[`bv
				new SimpleFactory(LetsAjaxLabelModel.class), // f쐬t@Ng
				descriptor, // pbgɕ\16X16̃C[W
				descriptor);// pbgɕ\24X24̃C[W
		drawer.add(creationEntry);

		// BUTTONc[̍쐬ƒǉ
		ImageDescriptor descriptor2 = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "button.gif");
		CreationToolEntry creationEntry2 = new CreationToolEntry("{^", // pbgɕ\镶
				"BUTTON", // c[`bv
				new SimpleFactory(LetsAjaxButtonModel.class), // f쐬t@Ng
				descriptor2, // pbgɕ\16X16̃C[W
				descriptor2);// pbgɕ\24X24̃C[W
		drawer.add(creationEntry2);

		// LinkButton
		ImageDescriptor linkButtonDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "linkbutton.gif");
		CreationToolEntry linkCreationEntry = new CreationToolEntry("N", // pbgɕ\镶
				"Link", // c[`bv
				new SimpleFactory(LetsAjaxLinkButtonModel.class), // f쐬t@Ng
				linkButtonDescriptor, // pbgɕ\16X16̃C[W
				linkButtonDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(linkCreationEntry);

		// RadioButton
		ImageDescriptor radioButtonDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "radiobutton.gif");
		CreationToolEntry radioCreationEntry = new CreationToolEntry("WI{^", // pbgɕ\镶
				"RadioButton", // c[`bv
				new SimpleFactory(LetsAjaxRadioButtonModel.class), // f쐬t@Ng
				radioButtonDescriptor, // pbgɕ\16X16̃C[W
				radioButtonDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(radioCreationEntry);

		// CheckBox
		ImageDescriptor checkBoxDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "checkbox.gif");
		CreationToolEntry checkBoxCreationEntry = new CreationToolEntry(
				"`FbN{bNX", // pbgɕ\镶
				"CheckBox", // c[`bv
				new SimpleFactory(LetsAjaxCheckBoxModel.class), // f쐬t@Ng
				checkBoxDescriptor, // pbgɕ\16X16̃C[W
				checkBoxDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(checkBoxCreationEntry);

		// Text
		ImageDescriptor descriptor3 = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "textfield.gif");
		CreationToolEntry creationEntry3 = new CreationToolEntry("eLXgtB[h", // pbgɕ\镶
				"TextField", // c[`bv
				new SimpleFactory(LetsAjaxTextFieldModel.class), // f쐬t@Ng
				descriptor3, // pbgɕ\16X16̃C[W
				descriptor3);// pbgɕ\24X24̃C[W
		drawer.add(creationEntry3);

		// TextArea
		ImageDescriptor textAreaDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "textarea.gif");
		CreationToolEntry textAreaCreationEntry = new CreationToolEntry(
				"eLXgGA", // pbgɕ\镶
				"TextArea", // c[`bv
				new SimpleFactory(LetsAjaxTextAreaModel.class), // f쐬t@Ng
				textAreaDescriptor, // pbgɕ\16X16̃C[W
				textAreaDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(textAreaCreationEntry);

		// SELECT BOX
		ImageDescriptor selectBoxDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "combo.gif");
		CreationToolEntry selectBoxCreationEntry = new CreationToolEntry(
				"R{{bNX", // pbgɕ\镶
				"ComboBox", // c[`bv
				new SimpleFactory(LetsAjaxComboBoxModel.class), // f쐬t@Ng
				selectBoxDescriptor, // pbgɕ\16X16̃C[W
				selectBoxDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(selectBoxCreationEntry);

		// IMAGE
		ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "image.gif");
		CreationToolEntry imageCreationEntry = new CreationToolEntry("C[W", // pbgɕ\镶
				"Image", // c[`bv
				new SimpleFactory(LetsAjaxImageModel.class), // f쐬t@Ng
				imageDescriptor, // pbgɕ\16X16̃C[W
				imageDescriptor);// pbgɕ\24X24̃C[W
		drawer.add(imageCreationEntry);

		return drawer;
	}

	/**
	 * pbgւ̊gi̕\
	 * 
	 * @return
	 */
	private PaletteDrawer getOtherComponentGroup() {

		// ipO[v
		PaletteDrawer otherDrawer = new PaletteDrawer("gi");

		// YUIJ_pJS
		ImageDescriptor yuiCalendarDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry yuiCalendarCreationEntry = new CreationToolEntry(
				"YUIJ_", // pbgɕ\镶
				"YUIJ_", // c[`bv
				new SimpleFactory(YuiCalendarModel.class), // f쐬t@Ng
				yuiCalendarDescriptor, // pbgɕ\16X16̃C[W
				yuiCalendarDescriptor);// pbgɕ\24X24̃C[W
		otherDrawer.add(yuiCalendarCreationEntry);

		// YUIAj[VpJS
		ImageDescriptor yuiAnimateDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry yuiAnimateCreationEntry = new CreationToolEntry(
				"YUIAj[V", // pbgɕ\镶
				"YUIAj[V", // c[`bv
				new SimpleFactory(YuiBasicAnimateModel.class), // f쐬t@Ng
				yuiAnimateDescriptor, // pbgɕ\16X16̃C[W
				yuiAnimateDescriptor);// pbgɕ\24X24̃C[W
		otherDrawer.add(yuiAnimateCreationEntry);
		return otherDrawer;
	}

	/**
	 * ėpT[rX̃pbgւ̔zu
	 * 
	 * @return
	 */
	private PaletteDrawer getServiceComponentGroup() {
		// ėpT[rXpiO[v
		PaletteDrawer serviceDrawer = new PaletteDrawer("ėpT[rXi");
		ImageDescriptor serviceDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "dataTable.gif");
		CreationToolEntry serviceCreationEntry = new CreationToolEntry(
				"f[^e[u", // pbgɕ\镶
				"Tablet", // c[`bv
				new SimpleFactory(LetsAjaxDataTableModel.class), // f쐬t@Ng
				serviceDescriptor, // pbgɕ\16X16̃C[W
				serviceDescriptor);// pbgɕ\24X24̃C[W
		serviceDrawer.add(serviceCreationEntry);

		// chartpJS
		ImageDescriptor ChartJsDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry chartJsCreationEntry = new CreationToolEntry("`[g", // pbgɕ\镶
				"`[g", // c[`bv
				new SimpleFactory(LetsAjaxChartModel.class), // f쐬t@Ng
				ChartJsDescriptor, // pbgɕ\16X16̃C[W
				ChartJsDescriptor);// pbgɕ\24X24̃C[W
		serviceDrawer.add(chartJsCreationEntry);
		return serviceDrawer;
	}

	/**
	 * JavaScriptĩpbgւ̔zu
	 * 
	 * @return
	 */
	private PaletteDrawer getJSComponentGroup() {
		// JSpO[v
		PaletteDrawer jsDrawer = new PaletteDrawer("JSi");

		// YUIAj[V(J[)pJS
		ImageDescriptor yuiColorAnimateJsDescriptor = ImageDescriptor
				.createFromFile(LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry yuiColorAnimateJsCreationEntry = new CreationToolEntry(
				"YUIAj[V(J[)pJS", // pbgɕ\镶
				"YUIAj[V(J[)pJS", // c[`bv
				new SimpleFactory(YuiColorAnimateJSModel.class), // f쐬t@Ng
				yuiColorAnimateJsDescriptor, // pbgɕ\16X16̃C[W
				yuiColorAnimateJsDescriptor);// pbgɕ\24X24̃C[W
		jsDrawer.add(yuiColorAnimateJsCreationEntry);

		return jsDrawer;
	}

	/**
	 * CAEgev[g̃O[vpbgւ̔zu
	 * 
	 * @return
	 */
	private PaletteDrawer getLauoutTemplateGroup() {
		// 
		PaletteDrawer jsDrawer = new PaletteDrawer("CAEg");
		ImageDescriptor layoutDescriptor = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry layoutCreationEntry = new CreationToolEntry("v[", // pbgɕ\镶
				"v[", // c[`bv
				new SimpleFactory(LetsAjaxPlainLayoutModel.class), // f쐬t@Ng
				layoutDescriptor, // pbgɕ\16X16̃C[W
				layoutDescriptor);// pbgɕ\24X24̃C[W
		jsDrawer.add(layoutCreationEntry);

		ImageDescriptor layoutDescriptor2 = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry layout2CreationEntry = new CreationToolEntry("Qig", // pbgɕ\镶
				"Qig", // c[`bv
				new SimpleFactory(LetsAjax2ColumnLayoutModel.class), // f쐬t@Ng
				layoutDescriptor2, // pbgɕ\16X16̃C[W
				layoutDescriptor2);// pbgɕ\24X24̃C[W
		jsDrawer.add(layout2CreationEntry);

		ImageDescriptor layoutDescriptor3 = ImageDescriptor.createFromFile(
				LetsAjaxEditor.class, "jsControl1.gif");
		CreationToolEntry layout3CreationEntry = new CreationToolEntry(
				"wb_[tQig", // pbgɕ\镶
				"wb_[tQig", // c[`bv
				new SimpleFactory(LetsAjax2ColumnHeaderLayoutModel.class), // f쐬t@Ng
				layoutDescriptor3, // pbgɕ\16X16̃C[W
				layoutDescriptor3);// pbgɕ\24X24̃C[W
		jsDrawer.add(layout3CreationEntry);

		return jsDrawer;
	}

	/**
	 * LAXt@CGfB^擾
	 * 
	 * @return
	 */
	private String getLaxFileName() {
		IFileEditorInput input = (IFileEditorInput) getEditorInput();
		if (input != null && input.getFile().getLocation() != null) {
			String fileName = input.getFile().getLocation().toString();
			return fileName;
		}
		return null;

	}

	/**
	 * t@C̕ۑB
	 * 
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		// Save
		String file = this.getLaxFileName();

		LetsAjaxBodyEditPart part = (LetsAjaxBodyEditPart) this.laxView
				.getContents();
		LetsAjaxLayoutFileManager manager = new LetsAjaxLayoutFileManager();
		manager.createLayoutFile((LetsAjaxBodyModel) part.getModel(), file);
		getCommandStack().markSaveLocation();
	}

	/**
	 * t@C̕ۑ
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#doSaveAs()
	 */
	public void doSaveAs() {
		// Save
		super.doSaveAs();
	}

	/**
	 * t@CɕύX`FbNtO
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#isDirty()
	 */
	public boolean isDirty() {
		return getCommandStack().isDirty();
	}

	// I[o[Ch
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#commandStackChanged(java.util.EventObject)
	 */
	public void commandStackChanged(java.util.EventObject event) {
		// ۑANV̗L/؂ւ
		firePropertyChange(IEditorPart.PROP_DIRTY);
		super.commandStackChanged(event);
	}

	// I[o[Ch
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		// TODO ꂽ\bhEX^u
		return false;
	}

	/**
	 * IDȄ\
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#initializeGraphicalViewer()
	 */
	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
		this.setLaxView(viewer);

		// ŏʂ̃f̐ݒ
		LetsAjaxBodyModel parent = new LetsAjaxBodyModel();// e
		parent.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY);

		// \̓ǂݍ
		String file = this.getLaxFileName();
		if (file == null || (file != null && "".equals(file))) {
			// ftHg̃[NXy[XLAXt@Cꍇ
			// ǂݍݏ
			String filePath = Platform.getInstanceLocation().getURL().getPath();
			file = filePath + this.getTitleToolTip();
		}
		File laxFile = new File(file);
		if (laxFile.exists()) {
			LetsAjaxLayoutFileManager fileManager = new LetsAjaxLayoutFileManager();
			fileManager.loadLayoutFile(laxFile.getAbsolutePath(), parent);
		}

		viewer.setContents(parent);// eŏʂ
		IFile iFile = ((IFileEditorInput) this.getEditorInput()).getFile();
		String mame = iFile.getName();
		this.setTitle(mame);

	}

	/**
	 * L[{[hƃANV֘At
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#configureGraphicalViewer()
	 */
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();

		GraphicalViewer viewer = getGraphicalViewer();
		// EditPartFactory̍쐬Ɛݒ
		viewer.setEditPartFactory(new LetsAjaxEditPartFactory());

		LetsAjaxContextMenuProvider contextProvider = new LetsAjaxContextMenuProvider(
				viewer);
		contextProvider.setRegistry(getActionRegistry());
		viewer.setContextMenu(contextProvider);
		getSite().registerContextMenu(contextProvider, viewer);

		// L[Enh̍쐬
		KeyHandler keyHandler = new KeyHandler();

		// DELL[ƍ폜ANVт
		keyHandler.put(KeyStroke.getPressed(SWT.DEL, 127, 0),
				getActionRegistry().getAction(ActionFactory.DELETE.getId()));

		// F2L[DirectEditActionт
		keyHandler.put(KeyStroke.getPressed(SWT.F2, 0), getActionRegistry()
				.getAction(GEFActionConstants.DIRECT_EDIT));

		// OtBJEr[ɃL[Enhݒ
		getGraphicalViewer().setKeyHandler(keyHandler);

		// L[EnhɂĂ͈ȉ̂悤ɂ΁A
		// J[\EL[ɂÏړ\ɂȂ܂B
		// OtBJEr[ɃL[Enhݒ
		getGraphicalViewer().setKeyHandler(
				new GraphicalViewerKeyHandler(getGraphicalViewer())
						.setParent(keyHandler));
	}

	/**
	 * ANV`B
	 * 
	 * @see org.eclipse.gef.ui.parts.GraphicalEditor#createActions()
	 */
	protected void createActions() {
		super.createActions();
		ActionRegistry registry = getActionRegistry();

		IAction action = new DirectEditAction((IWorkbenchPart) this);
		registry.registerAction(action);

		// 񂾂킩ȂȂĂ܂
		// IIuWFNgɂăANVXVKvꍇɂ
		// ȉ̂悤ɂāÃANVIDo^Ă
		getSelectionActions().add(action.getId());

		// ̐ANV
		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.LEFT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.CENTER);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.RIGHT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		// ̐ANV
		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.TOP);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.MIDDLE);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.BOTTOM);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

	}

	/**
	 * @param LaxView
	 *            LaxView ݒB
	 */
	public void setLaxView(GraphicalViewer laxView) {
		this.laxView = laxView;
	}
}