/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.js;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.DataSourceMethod;
import jp.co.cybec.laxGenerator.DataSourceService;
import jp.co.cybec.laxGenerator.attributes.js.JsBaseTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableJsTag
extends JsBaseTag {
    private String dataSourceId = "";
    private String jsType = "DWR";
    private List<String> dataList = new ArrayList<String>();
    private Map dataSourceMap;

    @Override
    protected String getJsFunction() {
        String scriptDefine = this.getFindFunctions();
        scriptDefine = scriptDefine + this.getSaveFunctions();
        scriptDefine = scriptDefine + this.getUpdateFunction();
        scriptDefine = scriptDefine + this.getDeleteFunction();
        return scriptDefine;
    }

    private String getFindFunctions() {
        DataSourceService service = (DataSourceService)this.dataSourceMap.get(this.dataSourceId);
        List findMethodList = service.getFindMethodList();
        String scriptDefine = "";
        for (DataSourceMethod method : findMethodList) {
            scriptDefine = scriptDefine + this.getFindFunction(method);
        }
        scriptDefine = scriptDefine + this.getFillTableFunction();
        return scriptDefine;
    }

    private String getFindFunction(DataSourceMethod method) {
        String scriptDefine = "function loadData_" + method.toFunction("") + " {\n" + "\tDWRUtil.useLoadingMessage(\"LOADING......\");\n" + "\tservice_" + method.toFunction("") + ";\n}\n" + "function service_" + method.toFunction("") + " {\n" + "\t " + this.dataSourceId + "." + method.toFunction("fillTable") + ";\n}\n";
        return scriptDefine;
    }

    private String getFillTableFunction() {
        String scriptDefine = "var dataCache = { };\nvar viewed = -1;\n";
        scriptDefine = scriptDefine + "function fillTable(dataList) {\n" + "\t" + "dwr.util.removeAllRows(\"dataTableBody\", { filter:function(tr) {\n" + "\t\treturn (tr.id != \"pattern\");\n" + "\t\t}});\n" + "\tvar data, id;\n" + "\tfor (var i = 0; i < dataList.length; i++) { \n" + "\t\tdata = dataList[i]; \n";
        for (String data : this.dataList) {
            if (data.equals("id")) {
                scriptDefine = scriptDefine + "\t\t" + data + " = data." + data + ";\n" + "\t\tdwr.util.setValue(\"id\", " + data + ");\n";
                scriptDefine = scriptDefine + "\t\tdwr.util.cloneNode(\"pattern\", { idSuffix:data.id });\n";
                continue;
            }
            scriptDefine = scriptDefine + "\t\tvar " + data + " = data." + data + ";\n" + "\t\tdwr.util.setValue(\"" + data + "\" + id, " + data + ");\n";
        }
        scriptDefine = scriptDefine + "\t\tif ($(\"pattern\" + id).style.getPropertyValue) {\n" + "\t\t\t$(\"pattern\" + id).style.display = \"table-row\";\n" + "\t\t} else {\n" + "\t\t\t$(\"pattern\" + id).style.setAttribute('display', '');\n" + "\t\t\t$(\"pattern\" + id).style.setAttribute('display', 'table-row');\n" + "\t\t}\n" + "\t\tdataCache[id] = data;\n\t\tclearInputData();\n" + "\t}\n" + "}\n";
        return scriptDefine;
    }

    private String getSaveFunctions() {
        DataSourceService service = (DataSourceService)this.dataSourceMap.get(this.dataSourceId);
        String scriptDefine = "";
        DataSourceMethod addMethod = service.getUpdateMethod();
        DataSourceMethod updateMethod = service.getSaveMethod();
        scriptDefine = this.getSaveFunction(addMethod, updateMethod);
        return scriptDefine;
    }

    private String getSaveFunction(DataSourceMethod addMethod, DataSourceMethod updateMethod) {
        String scriptDefine = "\nfunction saveData(){\n";
        for (String data : this.dataList) {
            scriptDefine = scriptDefine + "\t var " + data + " = DWRUtil.getValue(\"inputData_" + data + "\");\n";
        }
        scriptDefine = scriptDefine + "\tif(id == -1) {\n" + "\t\t";
        scriptDefine = scriptDefine + this.dataSourceId + "." + updateMethod.toFunction("") + ";\n";
        scriptDefine = scriptDefine + "\t} else {\n";
        scriptDefine = scriptDefine + "\t\t" + this.dataSourceId + "." + addMethod.toFunction("") + ";\n";
        scriptDefine = scriptDefine + "\t}\n" + "\tDWRUtil.useLoadingMessage(\"LOADING......\");\n" + "\tloadData_findAll();\n";
        scriptDefine = scriptDefine + "}\n";
        return scriptDefine;
    }

    private String getUpdateFunction() {
        String scriptDefine = "\nfunction editData(eleid){\n \t\tDWRUtil.useLoadingMessage(\"LOADING......\");\n\t\tvar data = dataCache[eleid.substring(4)];\n";
        for (String data : this.dataList) {
            scriptDefine = scriptDefine + "\t DWRUtil.setValue(\"inputData_" + data + "\",data." + data + ");\n";
        }
        scriptDefine = scriptDefine + "}\n";
        return scriptDefine;
    }

    private String getDeleteFunction() {
        DataSourceService service = (DataSourceService)this.dataSourceMap.get(this.dataSourceId);
        DataSourceMethod deleteMethod = service.getDeleteMethod();
        String scriptDefine = "\nfunction deleteData(eleid) {\n\talert('DELETE.');\n\tdwr.engine.beginBatch();\n\t" + this.dataSourceId + "." + deleteMethod.toFunction("eleid.substring(6)") + ";\n\t" + "loadData_findAll();\n" + "\tdwr.engine.endBatch();\n" + " " + "}\n";
        scriptDefine = scriptDefine + "\nfunction clearInputData(){\n";
        for (String data : this.dataList) {
            if (data.equals("id")) {
                scriptDefine = scriptDefine + "\tDWRUtil.setValue(\"inputData_id\",-1);\n";
                continue;
            }
            scriptDefine = scriptDefine + "\tDWRUtil.setValue(\"inputData_" + data + "\",\"\");\n";
        }
        scriptDefine = scriptDefine + "}\n";
        return scriptDefine;
    }

    @Override
    public void setAttributes(Element element) {
        this.jsName = element.getAttributeValue("jsName");
        this.dataSourceId = element.getAttributeValue("dataSourceId");
    }

    @Override
    public void setDataSource(Map map) {
        this.dataSourceMap = map;
        if (map != null) {
            DataSourceService service = (DataSourceService)map.get(this.dataSourceId);
            this.dataList = service.getItemNameList();
        }
    }

    public String getJsType() {
        return this.jsType;
    }

    public void setJsType(String jsType) {
        this.jsType = jsType;
    }

    @Override
    public List<String> getDefineFileList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t<script type='text/javascript' src='../dwr/interface/" + this.dataSourceId + ".js'></script>\n");
        return list;
    }

    @Override
    public String getJsId() {
        return "dwr_js";
    }

    @Override
    public String toFunction() {
        return this.getJsFunction();
    }
}

