/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.js;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.js.JsBaseTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChartJsTag
extends JsBaseTag {
    protected String targetId = "";
    protected String chartType;
    private String width;
    private String height;

    @Override
    protected String getJsFunction() {
        String scriptDefine = "\n";
        scriptDefine = scriptDefine + this.getDataSetFunction();
        scriptDefine = scriptDefine + this.getOptionsFunction();
        scriptDefine = scriptDefine + this.getChartDrawFunction();
        return scriptDefine;
    }

    protected abstract String getDataSetFunction();

    protected String getOptionsFunction() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n" + this.id + "Options = {\n").append("\tpadding: {left: 60, right: 0, top: 10, bottom: 30},\n").append("\t// Set a custom colorScheme\n").append("\t// \u8272\u306e\u8a2d\u5b9a\u3092\u3057\u307e\u3059\n").append("\tcolorScheme: 'blue',\n").append("\t//colorScheme: new Hash({\n").append("\t//'January': '#1c4a7e',\n").append("\t\t//'February': '#bb5b3d',\n").append("\t\t//'March': '#3a8133',\n").append("\t\t//'April': '#813379'\n").append("\t//}),\n").append(this.getChartTypeOptions()).append("\t// Background color to render.\n").append("\tbackgroundColor: '#f2f2f2',\n").append("\tshouldFill: false,\n").append("\t// Set the labels.\n").append("\t//X\u8ef8\u306e\u30e9\u30d9\u30eb\u8a2d\u5b9a\n").append("\t//\u30b0\u30e9\u30d5\u8868\u793a\u3059\u308b\u30c7\u30fc\u30bf\u4ef6\u6570\u5206label\u8a2d\u5b9a\u3092\u3059\u308b\n").append("\t// \u7e26\u8ef8\u3001\u6a2a\u8ef8\u306e\u30d5\u30a9\u30f3\u30c8\u30ab\u30e9\u30fc\u306e\u8a2d\u5b9a\n").append("\tlabelColor: '#000000',\n").append("\txTicks: [\n").append("\t\t{v:0, label:'label1'},\n").append("\t\t{v:1, label:'label2'},\n").append("\t\t{v:2, label:'label3'},\n").append("\t\t{v:3, label:'label4'}\n").append("\t],\n").append("\t//Y\u8ef8\u306e\u30e9\u30d9\u30eb\u8a2d\u5b9a").append("\t//yTicks: [\n").append("\t\t//{v:0, label:'100'},\n").append("\t\t//{v:1, label:'200'},\n").append("\t\t//{v:2, label:'300'},\n").append("\t\t//{v:3, label:'400'}\n").append("\t//],\n").append("\tlegend: {\n").append("\t\tposition: {\n").append("\t\ttop: '" + (double)this.getHeight() * 1.6 * 0.3 + "px',\n").append("\t\tleft: '" + (double)this.getWidth() * 1.6 + "px'\n").append("\t}\n").append("}\n").append("};\n");
        return buf.toString();
    }

    protected abstract String getChartDrawFunction();

    @Override
    public void setAttributes(Element element) {
        this.id = element.getAttributeValue("id");
        this.dataSourceId = element.getAttributeValue("dataSourceId");
        this.targetId = element.getAttributeValue("id");
        this.chartType = element.getAttributeValue("chartType");
        this.width = element.getAttributeValue("componentWidth");
        this.height = element.getAttributeValue("componentHeight");
    }

    @Override
    public List<String> getDefineFileList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t<script type='text/javascript' src='../dwr/interface/" + this.dataSourceId + ".js'></script>\n");
        return list;
    }

    @Override
    public void setDataSource(Map map) {
    }

    @Override
    public String toFunction() {
        return this.getJsFunction();
    }

    public int getHeight() {
        if (this.height == null || this.height != null && this.height.equals("")) {
            return 0;
        }
        return Integer.parseInt(this.height);
    }

    public int getWidth() {
        if (this.width == null || this.width != null && this.width.equals("")) {
            return 0;
        }
        return Integer.parseInt(this.width);
    }

    protected String getChartTypeOptions() {
        if (this.chartType.equals("HorizontalBarChart")) {
            return "\tbarOrientation:'horizontal',\n";
        }
        if (this.chartType.equals("VerticalBarChart")) {
            return "\tbarOrientation:'vertical',\n";
        }
        if (this.chartType.equals("PieChart")) {
            return "\tpieRadius: '0.4',\n";
        }
        return "";
    }

    @Override
    public String getJsId() {
        return "chart_js";
    }
}

