/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.DataSourceService;
import jp.co.cybec.laxGenerator.attributes.Tag;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.DataTableJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableTag
extends BaseTag {
    private String borderSize = "0";
    private String bgColor = "";
    private Map<String, BaseTag> cmpMap = new HashMap<String, BaseTag>();
    private String dataSourceId = "";
    private List<String> dataList = new ArrayList<String>();
    private Tag jsTag = null;

    public DataTableTag(String id) {
        this.id = id;
        this.jsTag = new DataTableJsTag();
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            divEnd = "</div>\n";
        }
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">";
        }
        return div;
    }

    @Override
    protected String getTagName() {
        String html = "\t<TABLE ";
        html = html + "id=\"" + this.id + "\" ";
        html = html + this.getBorderSize();
        html = html + this.getBgColor();
        html = html + ">\n";
        return html;
    }

    @Override
    protected String getTagsAttribute() {
        int i;
        int cols = this.dataList.size();
        String html = "\t<thead ><tr>";
        for (i = 0; i < cols; ++i) {
            html = html + "\t\t<th>" + this.dataList.get(i) + "</th>\n";
        }
        html = html + "\t</tr></thread>\n";
        html = html + " \t<tbody id=\"dataTableBody\">\n" + "\t\t<tr id=\"pattern\" style=\"display:none;\">\n";
        for (i = 0; i < cols; ++i) {
            html = html + "\t\t <td >\n" + "\t\t<span id=\"" + this.dataList.get(i) + "\">" + this.dataList.get(i) + "</span><br/>\n" + "\t\t</td>\n";
        }
        html = html + "\t\t<td >\n" + "\t\t<input id=\"edit\" type=\"button\" value=\"Edit\"" + " onclick=\"editData(this.id);\"/>\n" + "\t\t<input id=\"delete\" type=\"button\" value=\"Delete\"" + " onclick=\"deleteData(this.id);\"/>\n" + "\t\t</td>\n";
        html = html + "\t</tr>\n" + "\t</tbody>\n</table>\n";
        html = html + "\t<table >\n";
        for (i = 0; i < cols; ++i) {
            html = this.dataList.get(i).equals("id") ? html + "\t<tr>\n" + "\t\t<td>" + this.dataList.get(i) + "</td>\n" + "<input id=\"inputData_id\" type=\"hidden\" value=\"-1\"/>" : html + "\t<tr>\n" + "\t\t<td>" + this.dataList.get(i) + "</td>\n" + "\t\t<td><input id=\"inputData_" + this.dataList.get(i) + "\" type=\"text\" size=\"30\"/></td>\n" + "\t</tr>\n";
        }
        html = html + "\t</tr>\n" + "\t<tr>\n" + "\t\t<td colspan=\"2\" align=\"right\">\n" + "\t\t<small>(ID=<span id=\"id\">-1</span>)</small>\n" + "\t\t<input type=\"button\" value=\"Save\" onclick=\"saveData();\"/>\n" + "\t\t<input type=\"button\" value=\"Clear\" />\n" + "\t\t</td>\n" + "\t</tr>\n" + "\t</table>\n";
        return html;
    }

    @Override
    public void setAttributes(Element element) {
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.dataSourceId = element.getAttributeValue("dataSourceId");
        this.borderSize = element.getAttributeValue("tableBorder");
        this.jsTag.setAttributes(element);
    }

    public Map<String, BaseTag> getCmpMap() {
        return this.cmpMap;
    }

    public String getDataSourceId() {
        if (this.dataSourceId == null || this.dataSourceId != null && this.dataSourceId.equals("")) {
            return "dataSource";
        }
        return this.dataSourceId;
    }

    public String getId() {
        return this.id;
    }

    public String getBorderSize() {
        if (this.borderSize == null || this.borderSize != null && this.borderSize.equals("")) {
            return "";
        }
        return " border=\"" + this.borderSize + "\"";
    }

    public String getBgColor() {
        if (this.bgColor == null || this.bgColor != null && this.bgColor.equals("")) {
            return "";
        }
        return " bgColor=\"" + this.bgColor + "\"";
    }

    @Override
    public void setDataSource(Map map) {
        if (map != null) {
            DataSourceService service = (DataSourceService)map.get(this.dataSourceId);
            this.dataList = service.getItemNameList();
        }
        this.jsTag.setDataSource(map);
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }

    @Override
    public String getJsId() {
        return this.jsTag.getJsId();
    }

    @Override
    public String toFunction() {
        return this.jsTag.toFunction();
    }
}

