/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.extension;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.DataSourceService;
import jp.co.cybec.laxGenerator.attributes.Tag;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.BarChartJsTag;
import jp.co.cybec.laxGenerator.attributes.js.ChartJsTag;
import jp.co.cybec.laxGenerator.attributes.js.LineChartJsTag;
import jp.co.cybec.laxGenerator.attributes.js.PieChartJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartTag
extends BaseTag {
    private Tag jsTag;
    private String chartType;
    private String dataSourceId = "";

    public ChartTag(String idString) {
        this.id = idString;
    }

    @Override
    protected String getTagName() {
        return "<canvas  ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = " id=\"" + this.id + "\"";
        html = html + " width= '" + (double)super.getComponentWidth() * 1.6 + "'";
        html = html + " height= '" + (double)super.getComponentHeight() * 1.6 + "'";
        html = html + "/>\n";
        return html;
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            divEnd = "</div>\n";
        }
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        if (!super.getX().equals("") || !super.getY().equals("")) {
            div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        }
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.componentWidth = element.getAttributeValue("componentWidth");
        this.componentHeight = element.getAttributeValue("componentHeight");
        this.chartType = element.getAttributeValue("chartType");
        this.createChartJsTag(this.chartType);
        this.jsTag.setAttributes(element);
    }

    private void createChartJsTag(String chartType) {
        if ("HorizontalBarChart".equals(chartType)) {
            this.jsTag = new BarChartJsTag();
        } else if ("VerticalBarChart".equals(chartType)) {
            this.jsTag = new BarChartJsTag();
        } else if ("LineChart".equals(chartType)) {
            this.jsTag = new LineChartJsTag();
        } else if ("PieChart".equals(chartType)) {
            this.jsTag = new PieChartJsTag();
        }
        this.jsTag = (ChartJsTag)this.jsTag;
    }

    @Override
    public void setDataSource(Map map) {
        if (map != null) {
            DataSourceService dataSourceService = (DataSourceService)map.get(this.dataSourceId);
        }
        this.jsTag.setDataSource(map);
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }

    @Override
    public String getJsId() {
        return this.jsTag.getJsId();
    }

    @Override
    public String toFunction() {
        return this.jsTag.toFunction();
    }
}

