/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.base;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.ComponentJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxTag
extends BaseTag {
    private String defaultValue;
    private String size;
    private String isMultiple;
    private ComponentJsTag jsTag = null;

    public ComboBoxTag(String idString) {
        this.id = idString;
        this.jsTag = new ComponentJsTag();
    }

    @Override
    protected String getTagName() {
        return "<select ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = "id=\"" + this.id + "\"";
        html = html + this.getName();
        html = html + this.getSize();
        html = html + this.getIsMultiple();
        html = html + this.getScript();
        html = html + ">";
        html = html + this.getDefaultValue();
        html = html + "</select>\n";
        return html;
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        divEnd = "</div>\n";
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.name = element.getAttributeValue("name");
        this.defaultValue = element.getAttributeValue("defaultValue");
        this.size = element.getAttributeValue("size");
        this.isMultiple = element.getAttributeValue("isMultiple");
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.componentWidth = element.getAttributeValue("componentWidth");
        this.componentHeight = element.getAttributeValue("componentHeight");
        this.event = element.getAttributeValue("event");
        this.jsTag.setAttributes(element);
    }

    private String getScript() {
        StringBuilder script = new StringBuilder("");
        if (this.event != null && !this.event.equals("")) {
            script.append(" ").append(this.event).append("=\"").append(this.id).append("();\"");
        }
        return script.toString();
    }

    public String getName() {
        if (this.name == null || this.name != null && this.name.equals("")) {
            return "";
        }
        return " name=\"" + this.name + "\" ";
    }

    public String getDefaultValue() {
        if (this.defaultValue == null || this.defaultValue != null && this.defaultValue.equals("")) {
            return "";
        }
        return "<option value=\"1\">" + this.defaultValue + "</option>";
    }

    @Override
    public void setDataSource(Map map) {
        this.jsTag.setDataSource(map);
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }

    public String getIsMultiple() {
        if (this.isMultiple == null || this.isMultiple != null && this.isMultiple.equals("")) {
            return "";
        }
        if (this.isMultiple != null && this.isMultiple.equals("false")) {
            return "";
        }
        return " multiple";
    }

    public void setIsMultiple(String isMultiple) {
        this.isMultiple = isMultiple;
    }

    public String getSize() {
        if (this.size == null || this.size != null && this.size.equals("")) {
            return "";
        }
        return " size = \"" + this.size + "\"";
    }

    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public String getJsId() {
        return this.jsTag.getJsId();
    }

    @Override
    public String toFunction() {
        String scriptDefine = "function " + this.id + "() {\n" + "} \n";
        scriptDefine = scriptDefine + this.jsTag.toFunction();
        return scriptDefine;
    }
}

