/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.base;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.ComponentJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTag
extends BaseTag {
    private ComponentJsTag jsTag = null;

    public CheckBoxTag(String idString) {
        this.id = idString;
        this.jsTag = new ComponentJsTag();
    }

    @Override
    protected String getTagName() {
        return "<input type=checkbox  ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = "id=\"" + this.id + "\"";
        html = html + this.getName();
        html = html + this.getValue();
        html = html + this.getScript();
        html = html + "/>\n";
        return html;
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        divEnd = "</div>\n";
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.name = element.getAttributeValue("name");
        this.value = element.getAttributeValue("value");
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.componentWidth = element.getAttributeValue("componentWidth");
        this.componentHeight = element.getAttributeValue("componentHeight");
        this.jsTag.setAttributes(element);
    }

    private String getScript() {
        StringBuilder script = new StringBuilder("");
        if (this.event != null && !this.event.equals("")) {
            script.append(" ").append(this.event).append("=\"").append(this.id).append("();\"");
        }
        return script.toString();
    }

    public String getName() {
        if (this.name == null || this.name != null && this.name.equals("")) {
            return "";
        }
        return " name=\"" + this.name + "\" ";
    }

    public String getValue() {
        if (this.value == null || this.value != null && this.value.equals("")) {
            return "";
        }
        return " value=\"" + this.value + "\" ";
    }

    @Override
    public void setDataSource(Map map) {
        this.jsTag.setDataSource(map);
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }

    @Override
    public String getJsId() {
        return this.jsTag.getJsId();
    }

    @Override
    public String toFunction() {
        String scriptDefine = "function " + this.id + "() {\n" + "} \n";
        scriptDefine = scriptDefine + this.jsTag.toFunction();
        return scriptDefine;
    }
}

