/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jp.co.cybec.laxGenerator.CssDefine;
import jp.co.cybec.laxGenerator.DataSourceFileAnalyst;
import jp.co.cybec.laxGenerator.JsDefine;
import jp.co.cybec.laxGenerator.JsDependencyFileAnalyst;
import jp.co.cybec.laxGenerator.LayoutFileAnalyst;
import org.jdom.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaxFileManager {
    private WeakHashMap appInfoMaps = new WeakHashMap();
    private Map<String, List> layoutMaps = new WeakHashMap<String, List>();
    private HashMap<String, List> dataSourceMap = null;
    private final String fileName;
    private final String htmlFileName;
    private List jsTagList = new ArrayList();
    private List jsIdTagList = new ArrayList();
    public static final String LAYOUT_KEY_HEAD = "headTagList";
    public static final String LAYOUT_KEY_BODY = "bodyTagList";
    public static final String SCRIPT_LIST = "scriptList";
    public static final String SCRIPTFILE_NAME_LIST = "scriptNameList";
    public static final String CSS_NAME_LIST = "cssNameList";
    public static final String IMAGE_FILE_NAME_LIST = "imageFileNameList";

    public LaxFileManager(String layoutFile, String htmlFileName) {
        this.fileName = layoutFile;
        this.htmlFileName = htmlFileName;
    }

    public WeakHashMap toAppFiles(String dataSourceFileName, String dictionaryFile) {
        this.parseDataSourceFile(dataSourceFileName);
        this.parseLayoutFile();
        this.parseJsAndCssFile(dictionaryFile);
        return this.appInfoMaps;
    }

    private void parseLayoutFile() {
        LayoutFileAnalyst analyst = new LayoutFileAnalyst(this.fileName);
        try {
            analyst.setDataSourceMap(this.dataSourceMap);
            analyst.parse();
            this.layoutMaps = analyst.getLaxLayoutMap();
            this.appInfoMaps.putAll(this.layoutMaps);
            this.jsTagList = analyst.getJsBaseTagList();
            this.jsIdTagList = analyst.getJsTagIdList();
            this.appInfoMaps.put(SCRIPT_LIST, analyst.getJSScripts());
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseJsAndCssFile(String dictionaryFile) {
        JsDependencyFileAnalyst analyst = new JsDependencyFileAnalyst(dictionaryFile);
        try {
            analyst.parse();
            ArrayList headScriptList = new ArrayList();
            ArrayList<String> scriptNameList = new ArrayList<String>();
            ArrayList<String> cssNameList = new ArrayList<String>();
            ArrayList<String> imageFileList = new ArrayList<String>();
            ArrayList jsDefineList = new ArrayList();
            ArrayList cssDefineList = new ArrayList();
            headScriptList.addAll(this.jsTagList);
            this.extractCssDefineByJsId(analyst, jsDefineList, cssDefineList);
            this.extractScriptName(scriptNameList, jsDefineList);
            this.extractCssImageFileName(cssNameList, imageFileList, cssDefineList);
            scriptNameList.add(this.getScriptDefineForHtml());
            List headList = this.layoutMaps.get(LAYOUT_KEY_HEAD);
            headList.addAll(headScriptList);
            this.appInfoMaps.put(LAYOUT_KEY_HEAD, headList);
            this.appInfoMaps.put(SCRIPTFILE_NAME_LIST, scriptNameList);
            this.appInfoMaps.put(CSS_NAME_LIST, cssNameList);
            this.appInfoMaps.put(IMAGE_FILE_NAME_LIST, imageFileList);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void extractCssDefineByJsId(JsDependencyFileAnalyst analyst, List jsDefineList, List cssDefineList) {
        for (String jsId : this.jsIdTagList) {
            List<JsDefine> list = analyst.getJsLibsById(jsId);
            jsDefineList.addAll(list);
            CssDefine cssDefine = analyst.getCssByJsId(jsId);
            if (cssDefine == null) continue;
            cssDefineList.add(cssDefine);
        }
    }

    private void extractCssImageFileName(List<String> cssNameList, List<String> imageFileList, List cssDefineList) {
        Collections.sort(cssDefineList);
        CssDefine prevCssDefine = null;
        for (CssDefine define : cssDefineList) {
            if (prevCssDefine == null && define != null || prevCssDefine != null && define != null && prevCssDefine.compareTo(define) != 0) {
                cssNameList.add(define.getName());
            }
            imageFileList.addAll(define.getImageFileList());
            prevCssDefine = define;
        }
    }

    private void extractScriptName(List<String> scriptNameList, List jsDefineList) {
        Collections.sort(jsDefineList);
        JsDefine prevDefine = null;
        for (JsDefine define : jsDefineList) {
            if (prevDefine == null || prevDefine != null && prevDefine.compareTo(define) != 0) {
                scriptNameList.add(define.getName());
            }
            prevDefine = define;
        }
    }

    private void parseDataSourceFile(String dataSourceFileName) {
        if (dataSourceFileName == null || dataSourceFileName != null && dataSourceFileName.equals("")) {
            return;
        }
        DataSourceFileAnalyst analyst = new DataSourceFileAnalyst(dataSourceFileName);
        try {
            analyst.parse();
            this.dataSourceMap = analyst.getDataSourceMap();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getScriptDefineForHtml() {
        int index = this.htmlFileName.lastIndexOf(".html");
        if (index != -1) {
            return "js/" + this.htmlFileName.substring(0, index) + ".js";
        }
        return "js/" + this.htmlFileName + ".js";
    }
}

