/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterStatementInterface;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class ClusterResultSet
implements ResultSet {
    protected static final String MSG_WARN_SWITCH_DB = "ResultSet\u5185\u3067\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    protected static final String MSG_ERR_RECREATE = "ResultSet\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002";
    private ResultSet rs = null;
    private ClusterStatementInterface st = null;
    protected static Logger logger = Logger.getInstance();
    private List methodList = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    public ClusterResultSet(ClusterStatementInterface st, ResultSet rs) {
        this.st = st;
        this.rs = rs;
        this.methodList = new ArrayList();
    }

    private void setParameters(ResultSet rs) throws SQLException {
        logger.enteringTool();
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                calledMethod.invoke(rs);
            }
            catch (Exception e) {
                logger.err(e);
                throw new SQLException(MSG_ERR_RECREATE);
            }
            ++i;
        }
        logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args, Class[] parameterTypes) throws SQLException {
        logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args, parameterTypes);
        try {
            result = calledMethod.invoke(this.rs);
        }
        catch (Exception e) {
            logger.debugTool(MSG_WARN_SWITCH_DB + e.getMessage());
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.rs = this.st.getAnotherResultSet();
            try {
                this.setParameters(this.rs);
                result = calledMethod.invoke(this.rs);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        this.methodList.add(calledMethod);
        logger.exitingTool();
        return result;
    }

    public int getConcurrency() throws SQLException {
        return (Integer)this.clusterCall("getConcurrency", null, null);
    }

    public int getFetchDirection() throws SQLException {
        return (Integer)this.clusterCall("getFetchDirection", null, null);
    }

    public int getFetchSize() throws SQLException {
        return (Integer)this.clusterCall("getFetchSize", null, null);
    }

    public int getRow() throws SQLException {
        return (Integer)this.clusterCall("getRow", null, null);
    }

    public int getType() throws SQLException {
        return (Integer)this.clusterCall("getType", null, null);
    }

    public void afterLast() throws SQLException {
        this.clusterCall("afterLast", null, null);
    }

    public void beforeFirst() throws SQLException {
        this.clusterCall("beforeFirst", null, null);
    }

    public void cancelRowUpdates() throws SQLException {
        this.clusterCall("cancelRowUpdates", null, null);
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null, null);
    }

    public void close() throws SQLException {
        this.clusterCall("close", null, null);
        this.methodList.clear();
    }

    public void deleteRow() throws SQLException {
        this.clusterCall("deleteRow", null, null);
    }

    public void insertRow() throws SQLException {
        this.clusterCall("insertRow", null, null);
    }

    public void moveToCurrentRow() throws SQLException {
        this.clusterCall("moveToCurrentRow", null, null);
    }

    public void moveToInsertRow() throws SQLException {
        this.clusterCall("moveToInsertRow", null, null);
    }

    public void refreshRow() throws SQLException {
        this.clusterCall("refreshRow", null, null);
    }

    public void updateRow() throws SQLException {
        this.clusterCall("updateRow", null, null);
    }

    public boolean first() throws SQLException {
        return (Boolean)this.clusterCall("first", null, null);
    }

    public boolean isAfterLast() throws SQLException {
        return (Boolean)this.clusterCall("isAfterLast", null, null);
    }

    public boolean isBeforeFirst() throws SQLException {
        return (Boolean)this.clusterCall("isBeforeFirst", null, null);
    }

    public boolean isFirst() throws SQLException {
        return (Boolean)this.clusterCall("isFirst", null, null);
    }

    public boolean isLast() throws SQLException {
        return (Boolean)this.clusterCall("isLast", null, null);
    }

    public boolean last() throws SQLException {
        return (Boolean)this.clusterCall("last", null, null);
    }

    public boolean next() throws SQLException {
        return (Boolean)this.clusterCall("next", null, null);
    }

    public boolean previous() throws SQLException {
        return (Boolean)this.clusterCall("previos", null, null);
    }

    public boolean rowDeleted() throws SQLException {
        return (Boolean)this.clusterCall("rowDeleted", null, null);
    }

    public boolean rowInserted() throws SQLException {
        return (Boolean)this.clusterCall("rowInserted", null, null);
    }

    public boolean rowUpdated() throws SQLException {
        return (Boolean)this.clusterCall("rowUpdated", null, null);
    }

    public boolean wasNull() throws SQLException {
        return (Boolean)this.clusterCall("wasNull", null, null);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)this.clusterCall("getByte", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public double getDouble(int columnIndex) throws SQLException {
        return (Double)this.clusterCall("getDouble", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)this.clusterCall("getFloat", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE})).floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        return (Integer)this.clusterCall("getInt", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public long getLong(int columnIndex) throws SQLException {
        return (Long)this.clusterCall("getLong", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public short getShort(int columnIndex) throws SQLException {
        return (Short)this.clusterCall("getShort", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Integer(direction)}, new Class[]{Integer.TYPE});
    }

    public void setFetchSize(int rows) throws SQLException {
        this.clusterCall("getDouble", new Object[]{new Integer(rows)}, new Class[]{Integer.TYPE});
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.clusterCall("getDouble", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public boolean absolute(int row) throws SQLException {
        return (Boolean)this.clusterCall("absolute", new Object[]{new Integer(row)}, new Class[]{Integer.TYPE});
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)this.clusterCall("getBoolean", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public boolean relative(int rows) throws SQLException {
        return (Boolean)this.clusterCall("relative", new Object[]{new Integer(rows)}, new Class[]{Integer.TYPE});
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.clusterCall("getBytes", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.clusterCall("updateByte", new Object[]{new Integer(columnIndex), new Byte[x]}, new Class[]{Integer.TYPE, Byte.TYPE});
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.clusterCall("updateDouble", new Object[]{new Integer(columnIndex), new Double(x)}, new Class[]{Integer.TYPE, Double.TYPE});
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.clusterCall("updateFloat", new Object[]{new Integer(columnIndex), new Float(x)}, new Class[]{Integer.TYPE, Float.TYPE});
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.clusterCall("updateInt", new Object[]{new Integer(columnIndex), new Integer(x)}, new Class[]{Integer.TYPE, Integer.TYPE});
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.clusterCall("updateLong", new Object[]{new Integer(columnIndex), new Long(x)}, new Class[]{Integer.TYPE, Long.TYPE});
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.clusterCall("updateShort", new Object[]{new Integer(columnIndex), new Short(x)}, new Class[]{Integer.TYPE, Short.TYPE});
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.clusterCall("updateBoolean", new Object[]{new Integer(columnIndex), new Boolean(x)}, new Class[]{Integer.TYPE, Boolean.TYPE});
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateBytes", objectArray, classArray);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getAsciiStream", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getBinaryStream", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return (InputStream)this.clusterCall("getUnicodeStream", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateAsciiStream", objectArray, classArray);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateBinaryStream", objectArray, classArray);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.clusterCall("getCharacterStream", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.io.Reader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateCharacterStream", objectArray, classArray);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.clusterCall("getObject", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateObject", objectArray, classArray);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x, new Integer(scale)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateObject", objectArray, classArray);
    }

    public String getCursorName() throws SQLException {
        return (String)this.clusterCall("getCursorName", null, null);
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.clusterCall("getString", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateString", objectArray, classArray);
    }

    public byte getByte(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Byte)this.clusterCall("getByte", objectArray, classArray);
    }

    public double getDouble(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Double)this.clusterCall("getDouble", objectArray, classArray);
    }

    public float getFloat(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return ((Float)this.clusterCall("getFloat", objectArray, classArray)).floatValue();
    }

    public int findColumn(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Integer)this.clusterCall("findColumn", objectArray, classArray);
    }

    public int getInt(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Integer)this.clusterCall("getInt", objectArray, classArray);
    }

    public long getLong(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Long)this.clusterCall("getLong", objectArray, classArray);
    }

    public short getShort(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Short)this.clusterCall("getShort", objectArray, classArray);
    }

    public void updateNull(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("updateNull", objectArray, classArray);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Boolean)this.clusterCall("getBoolean", objectArray, classArray);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (byte[])this.clusterCall("getBytes", objectArray, classArray);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Byte(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Byte.TYPE;
        this.clusterCall("updateByte", objectArray, classArray);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Double(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Double.TYPE;
        this.clusterCall("updateDouble", objectArray, classArray);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Float(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Float.TYPE;
        this.clusterCall("updateFloat", objectArray, classArray);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Integer(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        this.clusterCall("updateInt", objectArray, classArray);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Long(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Long.TYPE;
        this.clusterCall("updateLong", objectArray, classArray);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Short(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Short.TYPE;
        this.clusterCall("updateShort", objectArray, classArray);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Boolean(x)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Boolean.TYPE;
        this.clusterCall("updateBoolean", objectArray, classArray);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateBytes", objectArray, classArray);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(columnIndex), new Integer(scale)}, new Class[]{Integer.TYPE, Integer.TYPE});
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateBytes", objectArray, classArray);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.clusterCall("getURL", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public Array getArray(int i) throws SQLException {
        return (Array)this.clusterCall("getArray", new Object[]{new Integer(i)}, new Class[]{Integer.TYPE});
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateArray", objectArray, classArray);
    }

    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.clusterCall("getBlob", new Object[]{new Integer(i)}, new Class[]{Integer.TYPE});
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.clusterCall("updateBlob", objectArray, classArray);
    }

    public Clob getClob(int i) throws SQLException {
        return (Clob)this.clusterCall("getClob", new Object[]{new Integer(i)}, new Class[]{Integer.TYPE});
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateClob", objectArray, classArray);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateDate", objectArray, classArray);
    }

    public Ref getRef(int i) throws SQLException {
        return (Ref)this.clusterCall("getRef", new Object[]{new Integer(i)}, new Class[]{Integer.TYPE});
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateRef", objectArray, classArray);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return (ResultSetMetaData)this.clusterCall("getMetaData", null, null);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null, null);
    }

    public Statement getStatement() throws SQLException {
        return (Statement)this.clusterCall("getStatement", null, null);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("updateTime", objectArray, classArray);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{new Integer(columnIndex)}, new Class[]{Integer.TYPE});
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.clusterCall("updateTimestamp", new Object[]{new Integer(columnIndex), x}, new Class[]{Integer.TYPE});
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (InputStream)this.clusterCall("getAsciiStream", objectArray, classArray);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (InputStream)this.clusterCall("getBinaryStream", objectArray, classArray);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (InputStream)this.clusterCall("getUnicodeStream", objectArray, classArray);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x, new Integer(length)};
        Class[] classArray = new Class[3];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateAsciiStream", objectArray, classArray);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x, new Integer(length)};
        Class[] classArray = new Class[3];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateBinaryStream", objectArray, classArray);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Reader)this.clusterCall("getCharacterStream", objectArray, classArray);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        Object[] objectArray = new Object[]{columnName, reader, new Integer(length)};
        Class[] classArray = new Class[3];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.io.Reader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateCharacterStream", objectArray, classArray);
    }

    public Object getObject(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return this.clusterCall("getObject", objectArray, classArray);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateObject", objectArray, classArray);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x, new Integer(scale)};
        Class[] classArray = new Class[3];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        classArray[2] = Integer.TYPE;
        this.clusterCall("updateObject", objectArray, classArray);
    }

    public Object getObject(int i, Map map) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(i), map};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        return this.clusterCall("getObject", objectArray, classArray);
    }

    public String getString(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (String)this.clusterCall("getString", objectArray, classArray);
    }

    public void updateString(String columnName, String x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateString", objectArray, classArray);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (BigDecimal)this.clusterCall("getBigDecimal", objectArray, classArray);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        Object[] objectArray = new Object[]{columnName, new Integer(scale)};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Integer.TYPE;
        return (BigDecimal)this.clusterCall("getBigDecimal", objectArray, classArray);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateBigDecimal", objectArray, classArray);
    }

    public URL getURL(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (URL)this.clusterCall("getURL", objectArray, classArray);
    }

    public Array getArray(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Array)this.clusterCall("getArray", objectArray, classArray);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$6;
        if (clazz2 == null) {
            try {
                clazz2 = class$6 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateArray", objectArray, classArray);
    }

    public Blob getBlob(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Blob)this.clusterCall("getBlob", objectArray, classArray);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$7;
        if (clazz2 == null) {
            try {
                clazz2 = class$7 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateBlob", objectArray, classArray);
    }

    public Clob getClob(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Clob)this.clusterCall("getClob", objectArray, classArray);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateClob", objectArray, classArray);
    }

    public Date getDate(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Date)this.clusterCall("getDate", objectArray, classArray);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$9;
        if (clazz2 == null) {
            try {
                clazz2 = class$9 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateDate", objectArray, classArray);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), cal};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Date)this.clusterCall("getDate", objectArray, classArray);
    }

    public Ref getRef(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Ref)this.clusterCall("getRef", objectArray, classArray);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$10;
        if (clazz2 == null) {
            try {
                clazz2 = class$10 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateRef", objectArray, classArray);
    }

    public Time getTime(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Time)this.clusterCall("getTime", objectArray, classArray);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$11;
        if (clazz2 == null) {
            try {
                clazz2 = class$11 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateTime", objectArray, classArray);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), cal};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Time)this.clusterCall("getTime", objectArray, classArray);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        Object[] objectArray = new Object[]{columnName};
        Class[] classArray = new Class[1];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Timestamp)this.clusterCall("getTimestamp", objectArray, classArray);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        Object[] objectArray = new Object[]{columnName, x};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        this.clusterCall("updateTimestamp", objectArray, classArray);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(columnIndex), cal};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$13;
        if (clazz == null) {
            try {
                clazz = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        return (Timestamp)this.clusterCall("getTimestamp", objectArray, classArray);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        Object[] objectArray = new Object[]{columnName, map};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$12;
        if (clazz2 == null) {
            try {
                clazz2 = class$12 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return this.clusterCall("getObject", objectArray, classArray);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{columnName, cal};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Date)this.clusterCall("getDate", objectArray, classArray);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{columnName, cal};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Time)this.clusterCall("getTime", objectArray, classArray);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{columnName, cal};
        Class[] classArray = new Class[2];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$13;
        if (clazz2 == null) {
            try {
                clazz2 = class$13 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        return (Timestamp)this.clusterCall("getTimestamp", objectArray, classArray);
    }
}

