/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc;

import com.lavans.util.Config;
import com.lavans.util.Logger;
import com.lavans.util.jdbc.DBManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DriverWrapper
implements Driver {
    private static final Logger logger = Logger.getInstance();
    private static final String CONFIG_FILE = "lavansutil.xml";
    private static final String CONFIG_SECTION = "database";
    private static final String DRIVER_URL = "jdbc:lavans";
    private Driver driver = null;

    static {
        logger.enteringTool();
        try {
            DriverManager.registerDriver(new DriverWrapper());
        }
        catch (Exception e) {
            logger.err(e);
            e.printStackTrace();
        }
        logger.exitingTool();
    }

    public DriverWrapper() {
        logger.enteringTool();
        Element conf = (Element)Config.getInstance(CONFIG_FILE).getNode(CONFIG_SECTION);
        NodeList nodeList = conf.getChildNodes();
        String driverName = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Element dbConf;
            String name;
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 8 && (name = (dbConf = (Element)nodeList.item(i)).getNodeName()).equals("default")) {
                driverName = dbConf.getAttribute("driver");
                break;
            }
            ++i;
        }
        if (driverName == null) {
            logger.err("database-default\u8a2d\u5b9a\u60c5\u5831\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u3002");
            return;
        }
        try {
            this.driver = (Driver)Class.forName(driverName).newInstance();
            logger.debug("load success.[" + this.driver.getClass().getName() + "]");
        }
        catch (Exception e) {
            logger.err(e);
        }
        logger.exitingTool();
    }

    public Connection connect(String arg0, Properties arg1) throws SQLException {
        logger.debugTool("DriverWrapper#connect()");
        return DBManager.getConnection();
    }

    public boolean acceptsURL(String url) throws SQLException {
        logger.debugTool("DriverWrapper#acceptsURL()");
        return url.startsWith(DRIVER_URL);
    }

    public boolean equals(Object arg0) {
        return this.driver.equals(arg0);
    }

    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return this.driver.getPropertyInfo(arg0, arg1);
    }

    public int hashCode() {
        return this.driver.hashCode();
    }

    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }
}

