/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.cluster.ClusterPreparedStatement;
import com.lavans.util.jdbc.cluster.ClusterStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class ClusterCallableStatement
extends ClusterPreparedStatement
implements CallableStatement {
    private CallableStatement st = null;
    private ClusterConnection con = null;
    private List methodList = null;

    public ClusterCallableStatement(ClusterConnection con, CallableStatement st) {
        super(con, st);
        this.con = con;
        this.st = st;
        this.methodList = new ArrayList();
    }

    public void reupdateStatement(Statement st) throws SQLException {
        ClusterStatement.logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = (CallableStatement)st;
        super.reupdateStatement(st);
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                ClusterStatement.logger.debugTool(calledMethod.toString());
                calledMethod.invoke(st);
            }
            catch (Exception e) {
                ClusterStatement.logger.err(e);
                throw new SQLException("Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002");
            }
            ++i;
        }
        ClusterStatement.logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args, boolean saveMethod) throws SQLException {
        ClusterStatement.logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args);
        ClusterStatement.logger.debugTool(calledMethod.toString());
        try {
            result = calledMethod.invoke(this.st);
        }
        catch (Exception e) {
            ClusterStatement.logger.err("\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002" + e.getCause().getMessage());
            this.con.notifyError(this);
            try {
                result = calledMethod.invoke(this.st);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        if (saveMethod) {
            this.methodList.add(calledMethod);
        }
        ClusterStatement.logger.exitingTool();
        return result;
    }

    public boolean wasNull() throws SQLException {
        return (Boolean)this.clusterCall("wasNull", null, false);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return (Byte)this.clusterCall("getByte", new Object[]{new Integer(parameterIndex)}, false);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return (Double)this.clusterCall("getDouble", new Object[]{new Integer(parameterIndex)}, false);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return ((Float)this.clusterCall("getFloat", new Object[]{new Integer(parameterIndex)}, false)).floatValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        return (Integer)this.clusterCall("getInt", new Object[]{new Integer(parameterIndex)}, false);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return (Long)this.clusterCall("getLong", new Object[]{new Integer(parameterIndex)}, false);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return (Short)this.clusterCall("getShort", new Object[]{new Integer(parameterIndex)}, false);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return (Boolean)this.clusterCall("getBoolean", new Object[]{new Integer(parameterIndex)}, false);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return (byte[])this.clusterCall("getBytes", new Object[]{new Integer(parameterIndex)}, false);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.clusterCall("registerOutParameter", new Object[]{new Integer(parameterIndex), new Integer(sqlType)}, true);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        Object[] args = new Object[]{new Integer(parameterIndex), new Integer(sqlType), new Integer(scale)};
        this.clusterCall("registerOutParameter", args, true);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this.clusterCall("getObject", new Object[]{new Integer(parameterIndex)}, false);
    }

    public String getString(int parameterIndex) throws SQLException {
        return (String)this.clusterCall("getString", new Object[]{new Integer(parameterIndex)}, false);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        Object[] args = new Object[]{new Integer(paramIndex), new Integer(sqlType), typeName};
        this.clusterCall("registerOutParameter", args, true);
    }

    public byte getByte(String parameterName) throws SQLException {
        return (Byte)this.clusterCall("getByte", new Object[]{parameterName}, false);
    }

    public double getDouble(String parameterName) throws SQLException {
        return (Double)this.clusterCall("getDouble", new Object[]{parameterName}, false);
    }

    public float getFloat(String parameterName) throws SQLException {
        return ((Float)this.clusterCall("getFloat", new Object[]{parameterName}, false)).floatValue();
    }

    public int getInt(String parameterName) throws SQLException {
        return (Integer)this.clusterCall("getInt", new Object[]{parameterName}, false);
    }

    public long getLong(String parameterName) throws SQLException {
        return (Long)this.clusterCall("getLong", new Object[]{parameterName}, false);
    }

    public short getShort(String parameterName) throws SQLException {
        return (Short)this.clusterCall("getShort", new Object[]{parameterName}, false);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return (Boolean)this.clusterCall("getBoolean", new Object[]{parameterName}, false);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return (byte[])this.clusterCall("getBytes", new Object[]{parameterName}, false);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.clusterCall("setByte", new Object[]{parameterName, new Byte(x)}, true);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.clusterCall("setDouble", new Object[]{parameterName, new Double(x)}, true);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.clusterCall("setFloat", new Object[]{parameterName, new Float(x)}, true);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.clusterCall("registerOutParameter", new Object[]{parameterName, new Integer(sqlType)}, true);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.clusterCall("setInt", new Object[]{parameterName, new Integer(x)}, true);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.clusterCall("setNull", new Object[]{parameterName, new Integer(sqlType)}, true);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        Object[] args = new Object[]{parameterName, new Integer(sqlType), new Integer(scale)};
        this.clusterCall("registerOutParameter", args, true);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.clusterCall("setLong", new Object[]{parameterName, new Long(x)}, true);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.clusterCall("setShort", new Object[]{parameterName, new Short(x)}, true);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.clusterCall("setBoolean", new Object[]{parameterName, new Boolean(x)}, true);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.clusterCall("setBytes", new Object[]{parameterName, x}, true);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(parameterIndex)}, false);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{new Integer(parameterIndex), new Integer(scale)}, false);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return (URL)this.clusterCall("getURL", new Object[]{new Integer(parameterIndex)}, false);
    }

    public Array getArray(int i) throws SQLException {
        return (Array)this.clusterCall("getArray", new Object[]{new Integer(i)}, false);
    }

    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.clusterCall("getBlob", new Object[]{new Integer(i)}, false);
    }

    public Clob getClob(int i) throws SQLException {
        return (Clob)this.clusterCall("getClob", new Object[]{new Integer(i)}, false);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{new Integer(parameterIndex)}, false);
    }

    public Ref getRef(int i) throws SQLException {
        return (Ref)this.clusterCall("getRef", new Object[]{new Integer(i)}, false);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{new Integer(parameterIndex)}, false);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{new Integer(parameterIndex)}, false);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        Object[] args = new Object[]{parameterName, x, new Integer(length)};
        this.clusterCall("setAsciiStream", args, true);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        Object[] args = new Object[]{parameterName, x, new Integer(length)};
        this.clusterCall("setBinaryStream", args, true);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        Object[] args = new Object[]{parameterName, reader, new Integer(length)};
        this.clusterCall("setCharacterStream", args, true);
    }

    public Object getObject(String parameterName) throws SQLException {
        return this.clusterCall("getObject", new Object[]{parameterName}, false);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.clusterCall("setObject", new Object[]{parameterName, x}, true);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.clusterCall("setObject", new Object[]{parameterName, x, new Integer(targetSqlType)}, true);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        Object[] args = new Object[]{parameterName, x, new Integer(targetSqlType), new Integer(scale)};
        this.clusterCall("setObject", args, true);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.clusterCall("getObject", new Object[]{new Integer(i), map}, false);
    }

    public String getString(String parameterName) throws SQLException {
        return (String)this.clusterCall("getString", new Object[]{parameterName}, false);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        Object[] args = new Object[]{parameterName, new Integer(sqlType), typeName};
        this.clusterCall("registerOutParameter", args, true);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.clusterCall("setNull", new Object[]{parameterName, new Integer(sqlType), typeName}, true);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.clusterCall("setString", new Object[]{parameterName, x}, true);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return (BigDecimal)this.clusterCall("getBigDecimal", new Object[]{parameterName}, false);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.clusterCall("setBigDecimal", new Object[]{parameterName, x}, true);
    }

    public URL getURL(String parameterName) throws SQLException {
        return (URL)this.clusterCall("getURL", new Object[]{parameterName}, false);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.clusterCall("setURL", new Object[]{parameterName, val}, true);
    }

    public Array getArray(String parameterName) throws SQLException {
        return (Array)this.clusterCall("getArray", new Object[]{parameterName}, false);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return (Blob)this.clusterCall("getBlob", new Object[]{parameterName}, false);
    }

    public Clob getClob(String parameterName) throws SQLException {
        return (Clob)this.clusterCall("getClob", new Object[]{parameterName}, false);
    }

    public Date getDate(String parameterName) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{parameterName}, false);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.clusterCall("setDate", new Object[]{parameterName, x}, true);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{new Integer(parameterIndex), cal}, false);
    }

    public Ref getRef(String parameterName) throws SQLException {
        return (Ref)this.clusterCall("getRef", new Object[]{parameterName}, false);
    }

    public Time getTime(String parameterName) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{parameterName}, false);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.clusterCall("setTime", new Object[]{parameterName, x}, true);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{new Integer(parameterIndex), cal}, false);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{parameterName}, false);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.clusterCall("setTimestamp", new Object[]{parameterName, x}, true);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{new Integer(parameterIndex), cal}, false);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.clusterCall("getObject", new Object[]{parameterName, map}, false);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return (Date)this.clusterCall("getDate", new Object[]{parameterName, cal}, false);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return (Time)this.clusterCall("getTime", new Object[]{parameterName, cal}, false);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return (Timestamp)this.clusterCall("getTimestamp", new Object[]{parameterName, cal}, false);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.clusterCall("setDate", new Object[]{parameterName, x, cal}, true);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.clusterCall("setTime", new Object[]{parameterName, x, cal}, true);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.clusterCall("setTimestamp", new Object[]{parameterName, x, cal}, true);
    }
}

