/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.cluster.ClusterStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ClusterPreparedStatement
extends ClusterStatement
implements PreparedStatement {
    private PreparedStatement st = null;
    private ClusterConnection con = null;
    private List methodList = null;

    public ClusterPreparedStatement(ClusterConnection con, PreparedStatement st) {
        super(con, st);
        this.con = con;
        this.st = st;
        this.methodList = new ArrayList();
    }

    public void reupdateStatement(Statement st) throws SQLException {
        ClusterStatement.logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = (PreparedStatement)st;
        super.reupdateStatement(st);
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                ClusterStatement.logger.debugTool(calledMethod.toString());
                calledMethod.invoke(st);
            }
            catch (Exception e) {
                ClusterStatement.logger.err(e);
                throw new SQLException("Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002");
            }
            ++i;
        }
        ClusterStatement.logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args) throws SQLException {
        ClusterStatement.logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args);
        ClusterStatement.logger.debugTool(calledMethod.toString());
        try {
            result = calledMethod.invoke(this.st);
        }
        catch (Exception e) {
            ClusterStatement.logger.err("\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002" + e.getCause().getMessage());
            this.con.notifyError(this);
            try {
                result = calledMethod.invoke(this.st);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        this.methodList.add(calledMethod);
        ClusterStatement.logger.exitingTool();
        return result;
    }

    public ResultSet getAnotherResultSet() throws SQLException {
        ClusterStatement.logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.con.notifyError(this);
        ResultSet rs = this.st.executeQuery();
        ClusterStatement.logger.exitingTool();
        return rs;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet result = (ResultSet)this.clusterCall("executeQuery", null);
        this.methodList.remove(this.methodList.size() - 1);
        return result;
    }

    public int executeUpdate() throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", null);
    }

    public boolean execute() throws SQLException {
        return (Boolean)this.clusterCall("execute", null);
    }

    public void addBatch() throws SQLException {
        this.clusterCall("addBatch", null);
    }

    public void clearParameters() throws SQLException {
        this.clusterCall("clearParameters", null);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.clusterCall("setByte", new Object[]{new Integer(parameterIndex), new Byte(x)});
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.clusterCall("setDouble", new Object[]{new Integer(parameterIndex), new Double(x)});
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.clusterCall("setFloat", new Object[]{new Integer(parameterIndex), new Float(x)});
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.clusterCall("setInt", new Object[]{new Integer(parameterIndex), new Integer(x)});
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.clusterCall("setNull", new Object[]{new Integer(parameterIndex), new Integer(sqlType)});
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.clusterCall("setLong", new Object[]{new Integer(parameterIndex), new Long(x)});
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.clusterCall("setShort", new Object[]{new Integer(parameterIndex), new Short(x)});
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.clusterCall("setBoolean", new Object[]{new Integer(parameterIndex), new Boolean(x)});
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.clusterCall("setBytes", new Object[]{new Integer(parameterIndex), x});
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.clusterCall("setAsciiStream", new Object[]{new Integer(parameterIndex), x, new Integer(length)});
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.clusterCall("setBinaryStream", new Object[]{new Integer(parameterIndex), x, new Integer(length)});
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.clusterCall("setUnicodeStream", new Object[]{new Integer(parameterIndex), x, new Integer(length)});
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.clusterCall("setCharacterStream", new Object[]{new Integer(parameterIndex), reader, new Integer(length)});
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.clusterCall("setObject", new Object[]{new Integer(parameterIndex), x});
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.clusterCall("setObject", new Object[]{new Integer(parameterIndex), x, new Integer(targetSqlType)});
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.clusterCall("setObject", new Object[]{new Integer(parameterIndex), x, new Integer(targetSqlType), new Integer(scale)});
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.clusterCall("setNull", new Object[]{new Integer(paramIndex), new Integer(sqlType), typeName});
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.clusterCall("setString", new Object[]{new Integer(parameterIndex), x});
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.clusterCall("setBigDecimal", new Object[]{new Integer(parameterIndex), x});
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.clusterCall("setURL", new Object[]{new Integer(parameterIndex), x});
    }

    public void setArray(int i, Array x) throws SQLException {
        this.clusterCall("setArray", new Object[]{new Integer(i), x});
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.clusterCall("setBlob", new Object[]{new Integer(i), x});
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.clusterCall("setClob", new Object[]{new Integer(i), x});
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.clusterCall("setDate", new Object[]{new Integer(parameterIndex), x});
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return (ParameterMetaData)this.clusterCall("getParameterMetaData", null);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.clusterCall("setRef", new Object[]{new Integer(i), x});
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return (ResultSetMetaData)this.clusterCall("getMetaData", null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.clusterCall("setTime", new Object[]{new Integer(parameterIndex), x});
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.clusterCall("setTimestamp", new Object[]{new Integer(parameterIndex), x});
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.clusterCall("setDate", new Object[]{new Integer(parameterIndex), x, cal});
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.clusterCall("setTime", new Object[]{new Integer(parameterIndex), x, cal});
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.clusterCall("setTimestamp", new Object[]{new Integer(parameterIndex), x, cal});
    }
}

