/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc;

import com.lavans.util.Config;
import com.lavans.util.Logger;
import com.lavans.util.Method;
import com.lavans.util.jdbc.ConnectionPool;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.cluster.ClusterConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DBManager {
    private static Logger logger = null;
    private static final String CLASSNAME;
    private static final String CONFIG_SECTION = "database";
    private static boolean statistics;
    private static Map countConnMap;
    public static Map dbMap;
    private static final int COUNT_GET = 0;
    private static final int COUNT_RELEASE = 1;
    private static boolean initFlg;
    private static final String CONFIG_FILE = "lavansutil.xml";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lavans.util.jdbc.DBManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz.getName();
        statistics = false;
        countConnMap = null;
        dbMap = null;
        initFlg = false;
        DBManager.init(CONFIG_FILE);
    }

    public static void init(String configFile) {
        logger = Logger.getInstance();
        dbMap = new HashMap();
        Element conf = (Element)Config.getInstance(configFile).getNode(CONFIG_SECTION);
        NodeList nodeList = conf.getChildNodes();
        if (nodeList == null) {
            return;
        }
        try {
            statistics = Boolean.valueOf(conf.getAttribute("statistics"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        countConnMap = new HashMap();
        String name = null;
        String driver = null;
        String url = null;
        String user = null;
        String pass = null;
        Object valid_sql = null;
        String max = null;
        String init = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 8) {
                Element dbConf = (Element)nodeList.item(i);
                name = dbConf.getNodeName();
                driver = dbConf.getAttribute("driver");
                url = dbConf.getAttribute("url");
                user = dbConf.getAttribute("user");
                pass = dbConf.getAttribute("pass");
                max = dbConf.getAttribute("max_connections");
                init = dbConf.getAttribute("init_connections");
                logger.debug("max:" + max + ", init:" + init);
                ConnectionPool pool = null;
                int node = 1;
                try {
                    node = Integer.parseInt(dbConf.getAttribute("cluster_node"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (node > 1) {
                    pool = new ClusterConnectionPool(driver, url, user, pass);
                    ArrayList<String> urlList = new ArrayList<String>(node);
                    urlList.add(url);
                    int j = 1;
                    while (j < node) {
                        urlList.add(dbConf.getAttribute("url" + (j + 1)));
                        ++j;
                    }
                    ((ClusterConnectionPool)pool).setUrlList(urlList);
                } else {
                    logger.debugTool("\u2605ConnectionPool\u4f5c\u6210:" + name);
                    pool = new ConnectionPool(driver, url, user, pass);
                }
                try {
                    pool.setMaxConnections(Integer.parseInt(max));
                }
                catch (NumberFormatException urlList) {
                    // empty catch block
                }
                try {
                    pool.setInitConnections(Integer.parseInt(init));
                }
                catch (NumberFormatException urlList) {
                    // empty catch block
                }
                pool.setStatistics(statistics);
                String logger_name = dbConf.getAttribute("logger");
                if (!logger_name.equals("")) {
                    Logger logger = Logger.getInstance(logger_name);
                    pool.setLogger(logger);
                }
                try {
                    pool.init();
                }
                catch (Exception e) {
                    logger.err(e);
                }
                dbMap.put(name, pool);
                logger.debug("create ConnectionPool[" + name + "]");
            }
            ++i;
        }
        initFlg = true;
    }

    public static BindConnection getConnection() throws SQLException {
        return DBManager.getConnection("default");
    }

    public static BindConnection getConnection(String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        if (statistics) {
            String method = Method.getMethodName(CLASSNAME);
            int[] count = (int[])countConnMap.get(method);
            if (count == null) {
                count = new int[]{1, 0};
                countConnMap.put(method, count);
            } else {
                count[0] = count[0] + 1;
            }
        }
        return pool.getConnection();
    }

    public static void releaseConnection(Connection conn) throws SQLException {
        DBManager.releaseConnection(conn, "default");
    }

    public static void releaseConnection(Connection conn, String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        conn.setAutoCommit(true);
        pool.releaseConnection(conn);
        if (statistics) {
            String method = Method.getMethodName(CLASSNAME);
            int[] count = (int[])countConnMap.get(method);
            if (count == null) {
                logger.debug("\u8cb8\u3057\u51fa\u3057\u3066\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u304b\u3089\u8fd4\u5374\u3055\u308c\u305f\u3002");
                count[0] = 0;
                count[1] = 1;
                countConnMap.put(method, count);
            } else {
                count[1] = count[1] + 1;
            }
        }
    }

    public static String viewConnectionPool() {
        if (!statistics) {
            return "";
        }
        Set col = countConnMap.keySet();
        ArrayList list = new ArrayList(col.size());
        Iterator ite = col.iterator();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        Collections.sort(list);
        StringBuffer buf = new StringBuffer();
        buf.append("Connection List\n");
        int i = 0;
        while (i < list.size()) {
            int[] count = (int[])countConnMap.get(list.get(i));
            buf.append(list.get(i) + "\t:" + count[0] + "\t:" + count[1] + "\t:" + (count[0] - count[1]) + "\n");
            ++i;
        }
        return buf.toString();
    }
}

