/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.logging.LoggingConnection;
import com.lavans.util.jdbc.stats.StatsConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class ConnectionPool {
    protected Logger logger = null;
    private String driver = null;
    private String url = null;
    private String user = null;
    private String pass = null;
    private boolean statistics = false;
    private int max_connections = 10;
    private int init_connections = 2;
    private List poolList = new Vector();
    private List useList = new Vector();
    protected final String MSG_ERR_TOOMANYCONNECTIONS = "\u63a5\u7d9a\u6570\u304c\u6700\u5927\u5024\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002";

    public ConnectionPool(String aDriver, String aUrl, String aUser, String aPass) {
        this.driver = aDriver;
        this.url = aUrl;
        this.user = aUser;
        this.pass = aPass;
        this.logger = Logger.getInstance();
    }

    public void setMaxConnections(int value) {
        this.max_connections = value;
    }

    public void setInitConnections(int value) {
        this.init_connections = value;
    }

    public void init() throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        DriverManager.registerDriver((Driver)Class.forName(this.driver).newInstance());
        int i = 0;
        while (i < this.init_connections) {
            this.poolList.add(this.createConnection());
            ++i;
        }
    }

    protected BindConnection createConnection() throws SQLException {
        this.logger.entering("\u2605ConnectionPool", "createConnection");
        if (this.poolList.size() + this.useList.size() >= this.max_connections) {
            throw new SQLException("\u63a5\u7d9a\u6570\u304c\u6700\u5927\u5024\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002");
        }
        Connection conn = null;
        this.logger.debug(String.valueOf(this.url) + ":" + this.user + ":" + this.pass);
        conn = DriverManager.getConnection(this.url, this.user, this.pass);
        if (this.statistics) {
            conn = new StatsConnection(conn);
        }
        conn = new LoggingConnection(conn);
        ((LoggingConnection)conn).setLogger(this.logger);
        BindConnection bcon = new BindConnection(conn);
        this.logger.exiting("\u2605ConnectionPool", "createConnection");
        return bcon;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkConnection(Connection conn) {
        boolean result = false;
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                result = true;
            }
            catch (SQLException sQLException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                st.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception e) {
            return result;
        }
        st.close();
        return result;
    }

    public BindConnection getConnection() throws SQLException {
        BindConnection conn = null;
        if (this.poolList.size() > 0 && !this.checkConnection(conn = (BindConnection)this.poolList.remove(0))) {
            try {
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            conn = null;
        }
        if (conn == null) {
            conn = this.createConnection();
        }
        this.useList.add(conn);
        return conn;
    }

    public void releaseConnection(Connection conn) throws SQLException {
        if (!this.useList.remove(conn)) {
            throw new SQLException("This is not my connection.");
        }
        this.poolList.add(conn);
    }

    public void setStatistics(boolean b) {
        this.statistics = b;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected int getMax_connections() {
        return this.max_connections;
    }

    protected String getPass() {
        return this.pass;
    }

    protected List getPoolList() {
        return this.poolList;
    }

    protected boolean isStatistics() {
        return this.statistics;
    }

    protected List getUseList() {
        return this.useList;
    }

    protected String getUser() {
        return this.user;
    }
}

