package jp.sourceforge.larch.core.command.impl
{
    import jp.sourceforge.larch.core.command.SyncCommand;

    /**
     * プロパティ設定コマンド
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class SetPropertyCommand extends SyncCommand
    {
        /**
         * コンストラクタ
         * @param aTarget 設定先
         * @param aTargetProperty 設定先のプロパティ名
         * @param aValue 設定する値
         */
        public function SetPropertyCommand(aTarget:Object, aTargetProperty:String, aValue:Object)
        {
            super(aTarget, aTargetProperty);
            value = aValue;
        }

        /** 設定する値 */
        private var value:Object;

        /**
         * プロパティに値を設定します。
         * @return 常にtrue
         */
        override protected function doExecute():Boolean
        {
            resultValue = value;
            return true;
        }
    }
}