package jp.sourceforge.larch.core.command
{
    /**
     * 複数コマンド順次実行コマンド
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class SequenceCommand extends Command
    {
        /**
         * commandsの配列の順序でコマンドを実行します。
         * @param commands 順次実行するコマンド
         */
        public function SequenceCommand(commands:Array)
        {
            super();
            var i:int;
            for(i = 0; i < commands.length - 1; i++)
            {
                Command(commands[i]).nextCommand = Command(commands[i + 1]);
            }
            if(commands.length != 0)
                firstCommand = Command(commands[0]);
        }

        /** 先頭のコマンド */
        private var firstCommand:Command;

        /**
         * 先頭のコマンドを実行します。
         */
        override public function execute():void
        {
            if(firstCommand)
                firstCommand.execute();
        }
    }
}