package jp.sourceforge.larch.core.command
{
    /**
     * 非同期処理コマンド基底クラス
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class AsyncCommand extends Command
    {
        /**
         * コンストラクタ
         * @param aTarget 結果の設定先
         * @param aTargetProperty 結果の設定先のプロパティ名
         */
        public function AsyncCommand(aTarget:Object=null, aTargetProperty:String=null)
        {
            super(aTarget, aTargetProperty);
        }

        /**
         * サブクラスのコマンド処理を実行します。
         */
        override public function execute():void
        {
            commandResult = false;
            doExecute();
        }

        /**
         * コマンドの処理を実行します。
         * サブクラスにて実装してください。
         * コマンド実行後、実行結果をprotectedメンバ変数resultに設定してください。
         */
        protected function doExecute():void
        {
            throw new Error("オーバーライド実装してください。");
        }

        /**
         * サブクラスのコマンド実行結果のバンディングメソッドです。
         * サブクラスの処理が正常終了の場合、次のコマンドを実行します。
         */
        protected function set commandResult(value:Boolean):void
        {
            if(value && nextCommand)
                nextCommand.execute();
        }
    }
}