/*
 *  KZ ODBC
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */
#ifndef KZ_ODBC_H
#define KZ_ODBC_H
/**********************************************************************
 kz_odbc.h  ODBC API̊ȈՃbp[NX
 Authors	Katsuhisa Ohfuji
 Version	0.1a(JŁj2008/03/11
 Version	0.2a(JŁj2008/04/14 NULLl̎擾G[̏C
									iNULLl󕶎ƂĎ擾j
 Version	0.3a(JŁj2008/05/16 J^O֐(tables,columns)̒ǉ
 Version	0.4a(JŁj2009/01/06 LinuxΉi{ꕔ֐̒ǉj
 Version	0.5a(JŁj2009/02/12 colinfo̓Y
 Version	0.6a(JŁj2009/02/27 gUNVΉ
									Fetch֐inextj̒ǉ
 Version	0.7a(JŁj2009/04/10 f[^擾̃oOC
 Version	0.7b(JŁj2009/05/07 ̃f[^^̒
 Version	0.8a(JŁj2009/05/12 NULLf[^[}̑Ή
 Version	0.8b(JŁj2009/12/11 64bitC
 Version    0.9          2011/04/14 oOtBbNX
 
 giVer0.6gς܂j
    1.kz_odbcIuWFNg쐬iRXgN^ODBCڑwj

     kz_odbc db("DSN=myaccess", false);
   
     DSNŃf[^[\[X̎ŵقADriverł̎w
     RXgN^2ڂ̈̓R~bg[hw肷
	   trueŎ蓮R~bg[hAfalseŎR~bg[h
	   蓮R~bg[hɂꍇAŌCommit()ĂяoKvB
	   
    2.SQL̔s
	 stmtIuWFNg쐬ASQL𔭍sB
	 
     kz_stmt stmt(&db);

     stmt, "INSERT INTO TEST(col1, col2) VALUE(?, ?)", "val1", 10, endsql;

     evfJ}(,)ŋ؂
     ŏkz_stmtIuWFNgw肵ASQL𕶎Ŏw肷B
     p[^[iHɑ΂lj𑱂Ďw
     p[^[Ŏwł^́A(eint)Aichar*)A
       _idouble,floatjAԁistruct tm)
       ȊǑ^w肷SQLsȂiŜjB
     0p[^Ɏw肷鎞͈xϐɓĂw肷B
     @iC++RpCł́A0́ANULL|C^Ɖ߂̂Łj
	 NULLlw肵Ƃ́Akz_odbc_nullw肷B
		stmt, "INSERT INTO TEST(col1) VALUE(?)", kz_odbc_null, endsql;
     ŌendsqlƋLqiLqȂSQLsȂjB
     
    3.lԂSQL̔s
    
     kz_resultset_array result = (stmt, "SELECT * FROM TEST", endsqlrs);
    
      ʃZbǵAkz_resultset_arrayiqjŕԂ
      SQLs̃J}̑Ŝ()ŊB
        Zq̗D揇ʂ̊֌WőŜȂƒlԂȂB
      ṒAendsqlrsƋLqiendsqlł͒lԂȂjB
    
    4.ʃZbg̎Qƕ@
     ʃZbgikz_resultset_arrayj́AȉtypdefɂȂĂB
     	std::vector< std::map< std::string, std::string> >
     SELECŤʂSĎ󂯎
     svectorɗmapi񖼂ƒlmap)ɂȂĂB
     @@cout << result[1]["ID"]
     @̂悤ɃANZXłB
     ʃZbǵAɕϊĕԂ
    5.G[̊mF
	 iserro֐ŃG[̗L
	 errorso֐ŃG[񂪎擾ł
	 @ʂ́Akz_string_array( std::vector< std::string > )ŕԂB
 Tv
@kz_odbc_sample.cppQƉB
 CZX
 @{\tgEFAGPLŔzzĂ܂B
**********************************************************************/
#include <string>
#include <strstream>
#include <vector>
#include <map>
#include <time.h>

#ifdef _WIN32
#include <windows.h>
#endif
#include <sql.h>
#include <sqlext.h>

class	kz_odbc_marker_end_sql{
	void *dmy;
public:
	kz_odbc_marker_end_sql() : dmy(0) {}	
};
inline kz_odbc_marker_end_sql get_kz_odbc_marker_end_sql() { return kz_odbc_marker_end_sql(); }
#define endsql get_kz_odbc_marker_end_sql()

class	kz_odbc_marker_end_sql_resultsets{
	void *dmy;
public:
	kz_odbc_marker_end_sql_resultsets() : dmy(0) {}
};
inline kz_odbc_marker_end_sql_resultsets get_kz_odbc_marker_end_sql_resultsets() { return kz_odbc_marker_end_sql_resultsets(); }
#define endsqlrs get_kz_odbc_marker_end_sql_resultsets()

class	kz_odbc_maker_null {
	void *dmy;
public:
	kz_odbc_maker_null() : dmy(0) {}
};
inline kz_odbc_maker_null get_kz_odbc_maker_null() { return kz_odbc_maker_null(); }
#define kz_odbc_null  get_kz_odbc_maker_null()

#define KZSQLSUCCESS(rc) ((rc==SQL_SUCCESS)||(rc==SQL_SUCCESS_WITH_INFO)||(rc==SQL_NO_DATA))
#define MAX_RESULT_COLUMN_NAME_LEN	128

typedef std::map< std::string, std::string>		kz_resultset;
typedef std::pair< std::string, std::string>	kz_resultset_pair;
typedef std::vector< kz_resultset >	kz_resultset_array;
typedef std::vector< std::string > kz_string_array;

class	kz_odbc {
friend class kz_stmt;
private:
	RETCODE		rc;
	HENV		henv;
	HDBC		hdbc;
	const char*	constr;
	bool		tranflg;
	
	void connect() {
		SQLAllocEnv(&henv);
		SQLAllocConnect(henv,&hdbc);
		rc = SQLDriverConnect(hdbc, 0, (SQLCHAR*)constr, SQL_NTS, 0, 0, 0,0);
		if ( !iserr() && tranflg ) {
			BeginTran();
		}
	}

	void dissconnect() {
		if ( tranflg ) { Rollback(); }
		if ( hdbc ) { SQLDisconnect(hdbc); }
		if ( hdbc ) { SQLFreeConnect(hdbc); hdbc = 0; }
		if ( henv ) { SQLFreeEnv(henv); henv = 0; }
	}
public:	
	bool iserr() { return !KZSQLSUCCESS(rc); }
public:
	void errclear() { rc = SQL_SUCCESS; }

public:
	kz_odbc() : rc(SQL_SUCCESS), henv(0), hdbc(0), constr(0), tranflg(false) {}
	kz_odbc( const kz_odbc &src) : rc(SQL_SUCCESS), henv(0), hdbc(0), constr(src.constr), tranflg(src.tranflg) {}
	kz_odbc( const char *l_constr, bool tranflg_) : rc(SQL_SUCCESS), henv(0), hdbc(0), constr(l_constr), tranflg(tranflg_) {}
	kz_odbc( const std::string &l_constr, bool tranflg_) : rc(SQL_SUCCESS), henv(0), constr(l_constr.c_str()), tranflg(tranflg_) {}
	void set_constr(const char *l_constr) { constr = l_constr; }
	~kz_odbc() { dissconnect(); }
	
	void BeginTran() {
		rc = SQLSetConnectAttr(hdbc, SQL_ATTR_AUTOCOMMIT, SQL_AUTOCOMMIT_OFF,0 );
	}

	void Commit() {
		rc = SQLEndTran( SQL_HANDLE_DBC, hdbc, SQL_COMMIT);
	}

	void Rollback() {
		rc = SQLEndTran( SQL_HANDLE_DBC, hdbc, SQL_ROLLBACK);
	}

	kz_string_array errors() {
		kz_string_array	result;
		char			state[6];
		SQLINTEGER		nerr;
		char			msg[SQL_MAX_MESSAGE_LENGTH+1];
		SQLSMALLINT		msglen;
		msg[SQL_MAX_MESSAGE_LENGTH] = '\0';
		
		while ( SQLError( henv, hdbc, 0, (SQLCHAR*)state, &nerr, (SQLCHAR*)msg, sizeof(msg), &msglen) == SQL_SUCCESS ) {
			std::strstream err;
			err << state << "(" << nerr << "):" << msg;
			result.push_back( std::string(std::istreambuf_iterator<char>(err), std::istreambuf_iterator<char>()));
		}
		return result;
	}
};

struct describe_col {
	std::string		name;
	SQLSMALLINT		typ;
	SQLULEN			siz;
	SQLSMALLINT		dd;
	describe_col( char *name_, SQLSMALLINT typ_, SQLULEN siz_, SQLSMALLINT dd_) : name(name_), typ(typ_), siz(siz_), dd(dd_) {}
};

class	kz_stmt {
	kz_odbc		*con;
	RETCODE		rc;
	HSTMT		hstmt;
	const char*	sql;
	int			count;
	std::vector<char>	buff;
	std::vector<TIMESTAMP_STRUCT>	tsary;
	std::vector< describe_col > colinfo;

public:	
	bool iserr() { return !KZSQLSUCCESS(rc); }
	void errclear() { rc = SQL_SUCCESS; count = 0; }

	void freestmt() {
		if ( hstmt ) { SQLFreeStmt(hstmt,SQL_DROP); hstmt = 0; count = 0; }
	}
	void allocstmt() {
		errclear();
		tsary.clear();
		freestmt();
		rc = SQLAllocStmt(con->hdbc,&hstmt);
	}

	void tables_(void) {
		if ( !con ) return;
		if ( !con->hdbc ) { con->connect(); }
		allocstmt();
		colinfo.clear();
		rc = SQLTables( hstmt, 0, 0, 0, 0, 0, 0, (SQLCHAR*)" 'TABLE', 'VIEW', 'ALIAS', 'SYNONYM' ", SQL_NTS);
	}
	
	void columns_(const char*table) {
		if ( !con ) return;
		if ( !con->hdbc ) { con->connect(); }
		allocstmt();
		colinfo.clear();
		rc = SQLColumns(hstmt, 0, 0, 0, 0, (SQLCHAR*)table, SQL_NTS, 0, 0);
	}
private:
	void execdirect(const char *sql) {
		if ( !con ) return;
		if ( !con->hdbc ) { con->connect(); }
		allocstmt();
		colinfo.clear();
		this->sql = sql;
		rc = SQLExecDirect(hstmt,(SQLCHAR*)sql,SQL_NTS);
	}
	void prepare(const char *sql) {
		if ( count != 0 ) return;
		if ( !con ) return;
		if ( !con->hdbc ) { con->connect(); }
		if ( iserr() ) return;
		allocstmt();
		if ( iserr() ) return;
		colinfo.clear();
		this->sql = sql;
		rc = SQLPrepare(hstmt, (SQLCHAR*)sql, SQL_NTS);
	}
	void bind( int ValueType, int ParameterType, const void *param, int ColumnSize = 0, int DecimalDigits = 0) {
		if ( count == 0 ) { count = 1; return; }
		if ( iserr() ) return;
		rc = SQLBindParameter(hstmt, count++, SQL_PARAM_INPUT, ValueType, ParameterType, ColumnSize, DecimalDigits,  (SQLPOINTER)param, 0, 0);
	}
	void bind_null() {
		static SQLLEN	sqlnull = SQL_NULL_DATA;
		if ( count == 0 ) { count = 1; return; }
		if ( iserr() ) return;
		rc = SQLBindParameter(hstmt, count++, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_VARCHAR, 0, 0,  0, 0, &sqlnull);
	}

	void execute() {
		if ( iserr() ) return;
		rc = SQLExecute(hstmt);
		count = 0;
	}
	void get_colinfo() {
		if ( !colinfo.empty() ) return;
		if ( iserr() ) return;
		SQLSMALLINT colnum;
		SQLNumResultCols( hstmt, &colnum);
		//colinfo.push_back( std::string() );	DescribeColSQLGetData̓Y1n܂ׁ̈A_~[}ĂAY𒲐邱Ƃɂ
		for ( int i = 1; i <= colnum; i++ ) {
			char cname[MAX_RESULT_COLUMN_NAME_LEN+1];
			SQLSMALLINT		cnamelength;
			SQLSMALLINT		ctype;
			SQLULEN			csize;
			SQLSMALLINT		cdd;
			SQLDescribeCol( hstmt, i, (SQLCHAR*)cname, MAX_RESULT_COLUMN_NAME_LEN, &cnamelength, &ctype, &csize, &cdd, 0);
			cname[MAX_RESULT_COLUMN_NAME_LEN] = '\0';
			colinfo.push_back(describe_col(cname, ctype, csize, cdd));
		}
	}

public:
	void get(size_t i, int &value, bool &nflg) { 
		SQLLEN siz;	
		rc = SQLGetData(hstmt, (SQLUSMALLINT)i, SQL_C_SLONG, &value, 0, &siz);
		nflg = (siz == SQL_NULL_DATA);
	 }
	void get(size_t i, unsigned int &value, bool &nflg) {
		SQLLEN siz;	
		rc = SQLGetData(hstmt, (SQLUSMALLINT)i, SQL_C_ULONG, &value, 0, &siz);
		nflg = (siz == SQL_NULL_DATA);
	}
	void get(size_t i, double &value, bool &nflg) {
		SQLLEN siz;	
		rc = SQLGetData(hstmt, (SQLUSMALLINT)i, SQL_C_DOUBLE, &value, 0, &siz);
		nflg = (siz == SQL_NULL_DATA);
	}
private:
	void get_buffer(size_t i, size_t &readtotal, bool &nflg) {
		SQLLEN	rbufsize = 0;
		SQLLEN	buffsize = (SQLLEN)buff.size();	// ǂݍ݉\ȃobt@TCY
		size_t	ofs = 0;
		readtotal = 0;
		SQLSMALLINT ctype = SQL_C_CHAR;
		SQLSMALLINT typ = colinfo[i-1].typ;
		if ( typ == SQL_CHAR || typ == SQL_VARCHAR || typ == SQL_BINARY || typ == SQL_LONGVARCHAR ) ctype = SQL_C_BINARY;
		while ( (rc = SQLGetData( hstmt, (SQLUSMALLINT)i, ctype , &buff[0] + ofs, buffsize, &rbufsize)) != SQL_NO_DATA && rbufsize >= buffsize )  {
			size_t	readsize = (rbufsize > buffsize) || (rbufsize == SQL_NO_TOTAL) ? buffsize : rbufsize;
			readtotal += readsize;
			ofs += readsize;
			// WindowsłMySQL ODBC Driver ňُIׂɁAJɑ΂3ȏSQLGetDataĂяoȂ悤2ڂ̌ĂяoŊmɓǂݍ߂悤Ƀobt@TCY𒲐B 
			// rbufsize{Kvȃobt@TCYԂ 
			SQLLEN oldbufsize = (SQLLEN)buff.size();
			SQLLEN newbufsize = (rbufsize > oldbufsize + buffsize) ? rbufsize :  oldbufsize+ buffsize;
			buffsize = newbufsize - oldbufsize;	// ǂݍ݉\iĂjobt@TCY
			buff.resize( newbufsize, 0);
		}
		readtotal += rbufsize;
		if ( rbufsize == SQL_NULL_DATA  ) {
			// NULL ͋󕶎ɂ
			buff[0] = '\0';
			readtotal = 1;
		}
		nflg = (rbufsize == SQL_NULL_DATA);
	}
public:
	void get(size_t i, std::string &str, bool &nflg) {
		size_t readtotal = 0;
		get_buffer(i, readtotal, nflg);
		str = std::string(buff.begin(), buff.begin() + readtotal);
	}

	bool fetch() {
		rc=SQLFetch(hstmt); 
		return rc == SQL_SUCCESS;
	};

private:
	kz_resultset resultset() {
		get_colinfo();
		kz_resultset	result;
		// SQLGetDatai1n܂肾Acolinfo0n܂Ŋi[ĂB
		for ( int i = 1; (size_t)i < colinfo.size() + 1; i++ ) {
			size_t readtotal = 0;
			bool nflg = false;
			get_buffer(i, readtotal, nflg);
			result.insert( kz_resultset_pair(colinfo[i-1].name, std::string(buff.begin(), buff.begin() + readtotal)));
		}
		return result;
	}

	kz_resultset_array resultset_array() {
		kz_resultset_array	result;
		if ( iserr() ) return result;
		for (rc=SQLFetch(hstmt); rc == SQL_SUCCESS; rc=SQLFetch(hstmt)) {
			result.push_back( resultset() );
		}
		return result;
	}


	kz_string_array resultset_string() {
		kz_string_array	result;
		rc=SQLFetch(hstmt);
		if ( rc != SQL_SUCCESS ) return result;
		get_colinfo();
		// SQLGetDatai1n܂肾Acolinfo0n܂Ŋi[ĂB
		for ( int i = 1; (size_t)i < colinfo.size() + 1; i++ ) {
			size_t readtotal = 0;
			bool nflg = false;
			get_buffer(i, readtotal, nflg);
			result.push_back(std::string(buff.begin(), buff.begin() + readtotal));
		}
		return result;
	}

public:
	kz_stmt() : con(0), rc(SQL_SUCCESS), hstmt(0), count(0), sql(""), buff(1024,0), tsary(), colinfo() {}
	kz_stmt(kz_odbc	*con_) : con(con_), rc(SQL_SUCCESS), hstmt(0), count(0), sql(""), buff(1024,0), tsary(), colinfo() {}
	~kz_stmt() { /*freestmt();*/ } // connectionƓĂȂ̂łꂪĂ΂ꂽƂɗꍇistmt̊JɂȂꍇ͒freestmtĂяo悤ɂ邱ƁB
	void setODBC(kz_odbc *con_) { con = con_; }

	kz_stmt& exec(const char *sql ) { execdirect(sql); return *this; }
	kz_resultset_array select( const char *sql ) { execdirect(sql); return resultset_array(); }
	kz_resultset_array tables() { tables_(); return resultset_array(); }
	kz_resultset_array columns( const char *table) { columns_(table); return resultset_array(); }
	kz_stmt& operator , ( const std::string &param) { *this, param.c_str(); return *this;}
	kz_stmt& operator , ( const char *param ) { prepare(param);	bind( SQL_C_CHAR, SQL_VARCHAR, param); return *this; }
	kz_stmt& operator , ( const unsigned  char &param ) { bind( SQL_C_UTINYINT, SQL_CHAR, &param); return *this; }
	kz_stmt& operator , ( const short &param ) { bind( SQL_C_SSHORT, SQL_SMALLINT, &param); return *this; }
	kz_stmt& operator , ( const unsigned short &param ) { bind( SQL_C_USHORT, SQL_SMALLINT, &param); return *this; }
	kz_stmt& operator , ( const int &param ) { bind( SQL_C_SLONG, SQL_INTEGER, &param); return *this; }
	kz_stmt& operator , ( const unsigned int &param ) { bind( SQL_C_ULONG, SQL_INTEGER, &param); return *this; }
	kz_stmt& operator , ( const long &param ) { bind( SQL_C_SLONG, SQL_INTEGER, &param); return *this; }
	kz_stmt& operator , ( const unsigned long &param ) { bind( SQL_C_ULONG, SQL_INTEGER, &param); return *this; }
	kz_stmt& operator , ( const float &param ) { bind( SQL_C_FLOAT, SQL_FLOAT, &param); return *this; }
	kz_stmt& operator , ( const double &param ) { bind( SQL_C_DOUBLE, SQL_DOUBLE, &param); return *this; }
	kz_stmt& operator , ( const struct tm &param ) { 
		tsary.push_back(TIMESTAMP_STRUCT());
		TIMESTAMP_STRUCT &ts = tsary.back();
		ts.year = param.tm_year + 1900;
		ts.month = param.tm_mon + 1;
		ts.day = param.tm_mday;
		ts.hour = param.tm_hour;
		ts.minute = param.tm_min;
		ts.second = param.tm_sec;
		bind( SQL_C_TIMESTAMP, SQL_TIMESTAMP, &(tsary.back()));
		return *this; 
	}
	kz_stmt& operator , ( const struct tm *param ) { return *this, *param; }
	kz_stmt& operator , (const kz_odbc_marker_end_sql& dmy) { execute(); return *this; }
	kz_resultset_array operator , (const kz_odbc_marker_end_sql_resultsets& dmy) { execute(); return resultset_array(); }
	kz_stmt& operator , ( const kz_odbc_maker_null& dmy) { bind_null(); return *this; }

	kz_string_array next() { return resultset_string();}
	std::vector< describe_col > &cinfo() { get_colinfo(); return this->colinfo;}

	kz_string_array errors() {
		kz_string_array	result;
		char			state[6];
		SQLINTEGER		nerr;
		char			msg[SQL_MAX_MESSAGE_LENGTH+1];
		SQLSMALLINT		msglen;
		msg[SQL_MAX_MESSAGE_LENGTH] = '\0';
		
		while ( SQLError( con->henv, con->hdbc, hstmt, (SQLCHAR*)state, &nerr, (SQLCHAR*)msg, sizeof(msg), &msglen) == SQL_SUCCESS ) {
			std::strstream err;
			err << state << "(" << nerr << "):" << msg;
			result.push_back( std::string(std::istreambuf_iterator<char>(err), std::istreambuf_iterator<char>()));
		}
		if ( !result.empty() && hstmt && sql != 0 ) {
			result.push_back( std::string("Last sql:") + sql);
		}
		return result;
	}

};

#endif
